/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes;

import cofh.core.util.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.ThermalFuel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ThermalFuelSerializer<T extends ThermalFuel>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected final int defaultEnergy;
    protected final IFactory<T> factory;

    public ThermalFuelSerializer(IFactory<T> factory, int defaultEnergy) {
        this.factory = factory;
        this.defaultEnergy = defaultEnergy;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        return this.factory.create(recipeId, energy, inputItems, inputFluids);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        int energy = buffer.func_150792_a();
        int numInputItems = buffer.func_150792_a();
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            inputItems.add(Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        int numInputFluids = buffer.func_150792_a();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            inputFluids.add(buffer.readFluidStack());
        }
        return this.factory.create(recipeId, energy, inputItems, inputFluids);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_150787_b(((ThermalFuel)((Object)recipe)).energy);
        int numInputItems = ((ThermalFuel)((Object)recipe)).inputItems.size();
        buffer.func_150787_b(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            ((ThermalFuel)((Object)recipe)).inputItems.get(i).func_199564_a(buffer);
        }
        int numInputFluids = ((ThermalFuel)((Object)recipe)).inputFluids.size();
        buffer.func_150787_b(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            buffer.writeFluidStack(((ThermalFuel)((Object)recipe)).inputFluids.get(i));
        }
    }

    public static interface IFactory<T extends ThermalFuel> {
        public T create(ResourceLocation var1, int var2, List<Ingredient> var3, List<FluidStack> var4);
    }
}

