/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes;

import cofh.core.util.recipes.SerializableRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class ThermalRecipe
extends SerializableRecipe {
    protected final List<Ingredient> inputItems = new ArrayList<Ingredient>();
    protected final List<FluidStack> inputFluids = new ArrayList<FluidStack>();
    protected final List<ItemStack> outputItems = new ArrayList<ItemStack>();
    protected final List<FluidStack> outputFluids = new ArrayList<FluidStack>();
    protected final List<Float> outputItemChances = new ArrayList<Float>();
    protected int energy;
    protected float experience;
    protected int minTicks;
    protected boolean catalyzable;

    protected ThermalRecipe(ResourceLocation recipeId, int energy, float experience, int minTicks, List<Ingredient> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> outputItemChances, List<FluidStack> outputFluids) {
        super(recipeId);
        this.energy = energy;
        this.experience = Math.max(0.0f, experience);
        this.minTicks = minTicks;
        if (inputItems != null) {
            this.inputItems.addAll(inputItems);
        }
        if (inputFluids != null) {
            this.inputFluids.addAll(inputFluids);
        }
        if (outputItems != null) {
            this.outputItems.addAll(outputItems);
            if (outputItemChances != null) {
                this.outputItemChances.addAll(outputItemChances);
            }
            if (this.outputItemChances.size() < this.outputItems.size()) {
                for (int i = this.outputItemChances.size(); i < this.outputItems.size(); ++i) {
                    this.outputItemChances.add(Float.valueOf(-1.0f));
                }
            }
            for (float f : this.outputItemChances) {
                this.catalyzable |= f >= 0.0f;
            }
        }
        if (outputFluids != null) {
            this.outputFluids.addAll(outputFluids);
        }
        this.trim();
    }

    private void trim() {
        ((ArrayList)this.inputItems).trimToSize();
        ((ArrayList)this.inputFluids).trimToSize();
        ((ArrayList)this.outputItems).trimToSize();
        ((ArrayList)this.outputFluids).trimToSize();
        ((ArrayList)this.outputItemChances).trimToSize();
    }

    public List<Ingredient> getInputItems() {
        return this.inputItems;
    }

    public List<FluidStack> getInputFluids() {
        return this.inputFluids;
    }

    public List<ItemStack> getOutputItems() {
        return this.outputItems;
    }

    public List<FluidStack> getOutputFluids() {
        return this.outputFluids;
    }

    public List<Float> getOutputItemChances() {
        return this.outputItemChances;
    }

    public int getEnergy() {
        return this.energy;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getMinTicks() {
        return this.minTicks;
    }

    public boolean isCatalyzable() {
        return this.catalyzable;
    }
}

