/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes;

import cofh.core.util.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ThermalRecipeSerializer<T extends ThermalRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected final int defaultEnergy;
    protected final IFactory<T> factory;

    public ThermalRecipeSerializer(IFactory<T> factory, int defaultEnergy) {
        this.factory = factory;
        this.defaultEnergy = defaultEnergy;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        float experience = 0.0f;
        int minTicks = -1;
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<Float> outputItemChances = new ArrayList<Float>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("result")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("result"));
        } else if (json.has("results")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("results"));
        } else if (json.has("output")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("output"));
        } else if (json.has("outputs")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("outputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        if (json.has("experience")) {
            experience = json.get("experience").getAsFloat();
        }
        if (json.has("min_ticks")) {
            minTicks = json.get("min_ticks").getAsInt();
        }
        return this.factory.create(recipeId, energy, experience, minTicks, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }

    @Nullable
    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        int energy = buffer.func_150792_a();
        float experience = buffer.readFloat();
        int minTicks = buffer.func_150792_a();
        int numInputItems = buffer.func_150792_a();
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            inputItems.add(Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        int numInputFluids = buffer.func_150792_a();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            inputFluids.add(buffer.readFluidStack());
        }
        int numOutputItems = buffer.func_150792_a();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>(numOutputItems);
        ArrayList<Float> outputItemChances = new ArrayList<Float>(numOutputItems);
        for (int i = 0; i < numOutputItems; ++i) {
            outputItems.add(buffer.func_150791_c());
            outputItemChances.add(Float.valueOf(buffer.readFloat()));
        }
        int numOutputFluids = buffer.func_150792_a();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>(numOutputFluids);
        for (int i = 0; i < numOutputFluids; ++i) {
            outputFluids.add(buffer.readFluidStack());
        }
        return this.factory.create(recipeId, energy, experience, minTicks, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_150787_b(((ThermalRecipe)((Object)recipe)).energy);
        buffer.writeFloat(((ThermalRecipe)((Object)recipe)).experience);
        buffer.func_150787_b(((ThermalRecipe)((Object)recipe)).minTicks);
        int numInputItems = ((ThermalRecipe)((Object)recipe)).inputItems.size();
        buffer.func_150787_b(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            ((ThermalRecipe)((Object)recipe)).inputItems.get(i).func_199564_a(buffer);
        }
        int numInputFluids = ((ThermalRecipe)((Object)recipe)).inputFluids.size();
        buffer.func_150787_b(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            buffer.writeFluidStack(((ThermalRecipe)((Object)recipe)).inputFluids.get(i));
        }
        int numOutputItems = ((ThermalRecipe)((Object)recipe)).outputItems.size();
        buffer.func_150787_b(numOutputItems);
        for (int i = 0; i < numOutputItems; ++i) {
            buffer.func_150788_a(((ThermalRecipe)((Object)recipe)).outputItems.get(i));
            buffer.writeFloat(((ThermalRecipe)((Object)recipe)).outputItemChances.get(i).floatValue());
        }
        int numOutputFluids = ((ThermalRecipe)((Object)recipe)).outputFluids.size();
        buffer.func_150787_b(numOutputFluids);
        for (int i = 0; i < numOutputFluids; ++i) {
            buffer.writeFluidStack(((ThermalRecipe)((Object)recipe)).outputFluids.get(i));
        }
    }

    public static interface IFactory<T extends ThermalRecipe> {
        public T create(ResourceLocation var1, int var2, float var3, int var4, List<Ingredient> var5, List<FluidStack> var6, List<ItemStack> var7, List<Float> var8, List<FluidStack> var9);
    }
}

