/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.core.util.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.TreeExtractorBoost;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeExtractorBoostSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<TreeExtractorBoost> {
    public TreeExtractorBoost read(ResourceLocation recipeId, JsonObject json) {
        float boostMult = 1.0f;
        int boostCycles = 8;
        Ingredient ingredient = RecipeJsonUtils.parseIngredient((JsonElement)json.get("ingredient"));
        if (json.has("boost_mod")) {
            boostMult = json.get("boost_mod").getAsFloat();
        }
        if (json.has("cycles")) {
            boostCycles = json.get("cycles").getAsInt();
        }
        return new TreeExtractorBoost(recipeId, ingredient, boostMult, boostCycles);
    }

    @Nullable
    public TreeExtractorBoost read(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        float boostMult = buffer.readFloat();
        int boostCycles = buffer.readInt();
        return new TreeExtractorBoost(recipeId, ingredient, boostMult, boostCycles);
    }

    public void write(PacketBuffer buffer, TreeExtractorBoost recipe) {
        recipe.ingredient.func_199564_a(buffer);
        buffer.writeFloat(recipe.boostMult);
        buffer.writeInt(recipe.boostCycles);
    }
}

