/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.world.biome;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.ThermalFeatures;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.world.ThermalWorld;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;

public class ThermalBiomeFeatures {
    private ThermalBiomeFeatures() {
    }

    public static void addOverworldOres(Biome biomeIn) {
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_APATITE).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_APATITE).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("apatite_ore")).func_176223_P(), 13)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(4, 16, 16))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_CINNABAR).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_CINNABAR).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("cinnabar_ore")).func_176223_P(), 5)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(1, 16, 16))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_NITER).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_NITER).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("niter_ore")).func_176223_P(), 7)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(2, 40, 12))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_SULFUR).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_SULFUR).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("sulfur_ore")).func_176223_P(), 7)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(2, 24, 12))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_COPPER).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_COPPER).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("copper_ore")).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 40, 0, 60))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_TIN).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_TIN).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("tin_ore")).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 20, 0, 40))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_LEAD).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_LEAD).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("lead_ore")).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 0, 0, 32))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_SILVER).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_SILVER).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("silver_ore")).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 0, 0, 32))));
        }
        if (ThermalFeatures.getFeature(ThermalFeatures.FLAG_RESOURCE_NICKEL).getAsBoolean() && ThermalFeatures.getFeature(ThermalWorld.FLAG_GEN_NICKEL).getAsBoolean()) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)ThermalCore.BLOCKS.get("nickel_ore")).func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(2, 0, 0, 128))));
        }
    }

    public static void addHostileSpawns(Biome biomeIn) {
        if (biomeIn.func_76747_a(EntityClassification.MONSTER).isEmpty()) {
            return;
        }
        Biome.Category category = biomeIn.func_201856_r();
        if (category == Biome.Category.EXTREME_HILLS || category == Biome.Category.MESA) {
            biomeIn.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(TCoreReferences.BASALZ_ENTITY, 10, 1, 3));
        }
        if (category == Biome.Category.DESERT || category == Biome.Category.MESA || category == Biome.Category.SAVANNA) {
            biomeIn.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(TCoreReferences.BLITZ_ENTITY, 10, 1, 3));
        }
        if (biomeIn.func_201851_b() == Biome.RainType.SNOW & biomeIn.func_150561_m() == Biome.TempCategory.COLD) {
            biomeIn.func_76747_a(EntityClassification.MONSTER).add(new Biome.SpawnListEntry(TCoreReferences.BLIZZ_ENTITY, 10, 1, 3));
        }
    }
}

