/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.client.gui.device;

import cofh.core.client.gui.IGuiAccess;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.client.gui.element.ElementButton;
import cofh.core.client.gui.element.ElementTexture;
import cofh.core.client.gui.element.panel.PanelBase;
import cofh.core.client.gui.element.panel.PanelConfiguration;
import cofh.core.inventory.container.ContainerCoFH;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.GuiHelper;
import cofh.core.util.control.IReconfigurable;
import cofh.core.util.control.ITransferControllable;
import cofh.core.util.helpers.SoundHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.client.gui.ThermalGuiHelper;
import cofh.thermal.core.client.gui.ThermalScreenBase;
import cofh.thermal.core.tileentity.ReconfigurableTile4Way;
import cofh.thermal.core.tileentity.ThermalTileBase;
import cofh.thermal.expansion.inventory.container.device.DeviceItemBufferContainer;
import cofh.thermal.expansion.tileentity.device.DeviceItemBufferTile;
import java.util.Collections;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DeviceItemBufferScreen
extends ThermalScreenBase<DeviceItemBufferContainer> {
    public static final String TEX_PATH = "thermal:textures/gui/devices/item_buffer.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermal:textures/gui/devices/item_buffer.png");
    public static final String TEX_INCREMENT = "cofh_core:textures/gui/elements/button_increment.png";
    public static final String TEX_DECREMENT = "cofh_core:textures/gui/elements/button_decrement.png";
    protected DeviceItemBufferTile tile;

    public DeviceItemBufferScreen(DeviceItemBufferContainer container, PlayerInventory inv, ITextComponent titleIn) {
        super((ContainerCoFH)container, inv, (ThermalTileBase)container.tile, StringHelper.getTextComponent((String)"block.thermal.device_item_buffer"));
        this.tile = container.tile;
        this.texture = TEXTURE;
        this.info = GuiHelper.generatePanelInfo((String)"info.thermal.device_item_buffer");
    }

    public void init() {
        super.init();
        this.addPanel((PanelBase)new PanelConfiguration((IGuiAccess)this, (ITransferControllable)this.tile, (IReconfigurable)this.tile, () -> this.tile.getFacing()).addConditionals(ThermalGuiHelper.createDefaultMachineConfigs((IGuiAccess)this, (String)this.name, (ReconfigurableTile4Way)this.tile)));
        this.addElement(new ElementTexture((IGuiAccess)this, 24, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_input.png", 20, 20));
        this.addElement(new ElementTexture((IGuiAccess)this, 132, 16).setSize(20, 20).setTexture("cofh_core:textures/gui/elements/info_output.png", 20, 20));
        this.addButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String input = StringHelper.format((long)this.tile.amountInput);
        String output = StringHelper.format((long)this.tile.amountOutput);
        this.getFontRenderer().func_211126_b(input, (float)this.getCenteredOffset(input, 34), 42.0f, 0x404040);
        this.getFontRenderer().func_211126_b(output, (float)this.getCenteredOffset(output, 142), 42.0f, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean handleElementButtonClick(String buttonName, int mouseButton) {
        float pitch;
        int change;
        if (DeviceItemBufferScreen.hasShiftDown()) {
            change = 64;
            pitch = 0.9f;
            if (mouseButton == 1) {
                change = 32;
                pitch = 0.8f;
            }
        } else if (DeviceItemBufferScreen.hasControlDown()) {
            change = 4;
            pitch = 0.5f;
            if (mouseButton == 1) {
                change = 1;
                pitch = 0.4f;
            }
        } else {
            change = 16;
            pitch = 0.7f;
            if (mouseButton == 1) {
                change = 8;
                pitch = 0.6f;
            }
        }
        int curInput = this.tile.amountInput;
        int curOutput = this.tile.amountOutput;
        switch (buttonName) {
            case "DecInput": {
                this.tile.amountInput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncInput": {
                this.tile.amountInput += change;
                pitch += 0.1f;
                break;
            }
            case "DecOutput": {
                this.tile.amountOutput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncOutput": {
                this.tile.amountOutput += change;
                pitch += 0.1f;
            }
        }
        SoundHelper.playClickSound((float)pitch);
        TileConfigPacket.sendToServer((TileCoFH)this.tile);
        this.tile.amountInput = curInput;
        this.tile.amountOutput = curOutput;
        return true;
    }

    protected void addButtons() {
        ElementBase decInput = new ElementButton((IGuiAccess)this, 19, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 16;
                int change2 = 8;
                if (DeviceItemBufferScreen.hasShiftDown()) {
                    change = 64;
                    change2 = 32;
                } else if (DeviceItemBufferScreen.hasControlDown()) {
                    change = 4;
                    change2 = 1;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.decrease_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)change2)));
            }
            return Collections.emptyList();
        }).setName("DecInput").setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountInput > 0);
        ElementBase incInput = new ElementButton((IGuiAccess)this, 35, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 16;
                int change2 = 8;
                if (DeviceItemBufferScreen.hasShiftDown()) {
                    change = 64;
                    change2 = 32;
                } else if (DeviceItemBufferScreen.hasControlDown()) {
                    change = 4;
                    change2 = 1;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.increase_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)change2)));
            }
            return Collections.emptyList();
        }).setName("IncInput").setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountInput < DeviceItemBufferTile.XFER_MAX);
        ElementBase decOutput = new ElementButton((IGuiAccess)this, 127, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 16;
                int change2 = 8;
                if (DeviceItemBufferScreen.hasShiftDown()) {
                    change = 64;
                    change2 = 32;
                } else if (DeviceItemBufferScreen.hasControlDown()) {
                    change = 4;
                    change2 = 1;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.decrease_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)change2)));
            }
            return Collections.emptyList();
        }).setName("DecOutput").setSize(14, 14).setTexture(TEX_DECREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput > 0);
        ElementBase incOutput = new ElementButton((IGuiAccess)this, 143, 56).setTooltipFactory((element, mouseX, mouseY) -> {
            if (element.enabled()) {
                int change = 16;
                int change2 = 8;
                if (DeviceItemBufferScreen.hasShiftDown()) {
                    change = 64;
                    change2 = 32;
                } else if (DeviceItemBufferScreen.hasControlDown()) {
                    change = 4;
                    change2 = 1;
                }
                return Collections.singletonList(new StringTextComponent(StringHelper.localize((String)"info.cofh.increase_by") + " " + StringHelper.format((long)change) + "/" + StringHelper.format((long)change2)));
            }
            return Collections.emptyList();
        }).setName("IncOutput").setSize(14, 14).setTexture(TEX_INCREMENT, 42, 14).setEnabled(() -> this.tile.amountOutput < DeviceItemBufferTile.XFER_MAX);
        this.addElement(decInput);
        this.addElement(incInput);
        this.addElement(decOutput);
        this.addElement(incOutput);
    }
}

