/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.plugins.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.plugins.jei.TCoreJeiPlugin;
import cofh.thermal.core.plugins.jei.ThermalRecipeCategory;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.expansion.client.gui.machine.MachinePressScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.util.recipes.machine.PressRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class PressRecipeCategory
extends ThermalRecipeCategory<PressRecipe> {
    protected IDrawableStatic tankBackground;
    protected IDrawableStatic tankOverlay;

    public PressRecipeCategory(IGuiHelper guiHelper, ResourceLocation uid) {
        super(guiHelper, uid);
        this.background = guiHelper.drawableBuilder(MachinePressScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_PRESS_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(1);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(2);
        this.tankBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(1), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(2), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends PressRecipe> getRecipeClass() {
        return PressRecipe.class;
    }

    public void setIngredients(PressRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.getOutputFluids());
    }

    public void setRecipe(IRecipeLayout layout, PressRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        List outputFluids = ingredients.getOutputs(VanillaTypes.FLUID);
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputs.get(i)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiItemStacks.init(0, true, 42, 5);
        guiItemStacks.init(1, true, 42, 41);
        guiItemStacks.init(2, false, 105, 23);
        guiFluidStacks.init(0, false, 141, 11, 16, 40, TCoreJeiPlugin.tankSize((int)4000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.tankOverlay));
        for (int i = 0; i < inputs.size(); ++i) {
            guiItemStacks.set(i, (List)inputs.get(i));
        }
        if (!outputs.isEmpty()) {
            guiItemStacks.set(2, (List)outputs.get(0));
        }
        if (!outputFluids.isEmpty()) {
            guiFluidStacks.set(0, (List)outputFluids.get(0));
        }
        this.addDefaultItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 2);
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(PressRecipe recipe, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, mouseX, mouseY);
        this.progressBackground.draw(69, 23);
        this.tankBackground.draw(140, 10);
        this.speedBackground.draw(43, 24);
        if (!recipe.getOutputFluids().isEmpty()) {
            RenderHelper.drawFluid((int)69, (int)23, (FluidStack)((FluidStack)recipe.getOutputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(69, 23);
            this.progressFluid.draw(69, 23);
        } else {
            this.progress.draw(69, 23);
        }
        this.speed.draw(43, 24);
    }
}

