/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.device;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.tileentity.ReconfigurableTile4Way;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.device.DeviceFluidBufferContainer;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class DeviceFluidBufferTile
extends ReconfigurableTile4Way
implements ITickableTileEntity {
    public static int XFER_MAX = 8000;
    public int amountInput = 1000;
    public int amountOutput = 1000;

    public DeviceFluidBufferTile() {
        super(TExpReferences.DEVICE_FLUID_BUFFER_TILE);
        this.tankInv.addTank(new FluidStorageCoFH(8000), StorageGroup.ACCESSIBLE);
        this.tankInv.addTank(new FluidStorageCoFH(8000), StorageGroup.ACCESSIBLE);
        this.tankInv.addTank(new FluidStorageCoFH(8000), StorageGroup.ACCESSIBLE);
        this.initHandlers();
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.timeCheckHalf()) {
                this.transferOutput();
                this.transferInput();
            }
            if (!this.redstoneControl.getState()) {
                this.isActive = false;
            }
        } else if (this.redstoneControl.getState()) {
            this.isActive = true;
        }
        this.updateActiveState(curActive);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceFluidBufferContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected void transferInput() {
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        int newTracker = this.inputTracker;
        boolean updateTracker = false;
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            FluidStorageCoFH tank;
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isInput()) continue;
            Iterator iterator = this.inputTanks().iterator();
            while (iterator.hasNext() && ((tank = (FluidStorageCoFH)iterator.next()).getSpace() <= 0 || !FluidHelper.extractFromAdjacent((TileEntity)this, (FluidStorageCoFH)tank, (int)Math.min(this.getInputFluidAmount(), tank.getSpace()), (Direction)side))) {
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.inputTracker = newTracker;
    }

    protected void transferOutput() {
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        int newTracker = this.outputTracker;
        boolean updateTracker = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isOutput()) continue;
            int j = this.outputTanks().size();
            while (j-- > 0 && !FluidHelper.insertIntoAdjacent((TileEntity)this, (FluidStorageCoFH)((FluidStorageCoFH)this.outputTanks().get(j)), (int)this.getOutputFluidAmount(), (Direction)side)) {
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.outputTracker = newTracker;
    }

    protected int getInputFluidAmount() {
        return this.amountInput;
    }

    protected int getOutputFluidAmount() {
        return this.amountOutput;
    }

    public PacketBuffer getConfigPacket(PacketBuffer buffer) {
        super.getConfigPacket(buffer);
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.amountInput);
        buffer.writeInt(this.amountOutput);
        return buffer;
    }

    public void handleConfigPacket(PacketBuffer buffer) {
        super.handleConfigPacket(buffer);
        this.amountInput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)XFER_MAX);
        this.amountOutput = MathHelper.clamp((int)buffer.readInt(), (int)0, (int)XFER_MAX);
    }

    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.amountInput = buffer.readInt();
        this.amountOutput = buffer.readInt();
    }

    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        this.amountInput = nbt.func_74762_e("AmountIn");
        this.amountOutput = nbt.func_74762_e("AmountOut");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("AmountIn", this.amountInput);
        nbt.func_74768_a("AmountOut", this.amountOutput);
        return nbt;
    }
}

