/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.dynamo;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.DynamoTileBase;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.dynamo.DynamoMagmaticContainer;
import cofh.thermal.expansion.util.managers.dynamo.MagmaticFuelManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;

public class DynamoMagmaticTile
extends DynamoTileBase {
    protected FluidStorageCoFH fuelTank = new FluidStorageCoFH(4000, arg_0 -> ((MagmaticFuelManager)MagmaticFuelManager.instance()).validFuel(arg_0));

    public DynamoMagmaticTile() {
        super(TExpReferences.DYNAMO_MAGMATIC_TILE);
        this.tankInv.addTank(this.fuelTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.field_204547_b, 1000);
        this.addAugmentSlots(ThermalConfig.dynamoAugments);
        this.initHandlers();
    }

    protected boolean canProcessStart() {
        return MagmaticFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) > 0 && this.fuelTank.getAmount() >= 100;
    }

    protected void processStart() {
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
        this.fuelMax = Math.round((float)MagmaticFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) * this.energyMod);
        this.fuel += this.fuelMax;
        this.fuelTank.modify(-100);
    }

    protected boolean cacheRenderFluid() {
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.fuelTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DynamoMagmaticContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(FLUID, (Object)this.renderFluid).build();
    }
}

