/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.references.CoFHTags;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.MachineTileProcess;
import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachineChillerContainer;
import cofh.thermal.expansion.util.managers.machine.ChillerRecipeManager;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.fluids.FluidStack;

public class MachineChillerTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(ChillerRecipeManager.instance()::validItem);
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();
    protected FluidStorageCoFH inputTank = new FluidStorageCoFH(8000, ChillerRecipeManager.instance()::validFluid);

    public MachineChillerTile() {
        super(TExpReferences.MACHINE_CHILLER_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = ChillerRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.inputTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    protected void resolveInputs() {
        if (!this.itemInputCounts.isEmpty() && !this.inputSlot.getItemStack().func_77973_b().func_206844_a(CoFHTags.Items.MACHINE_CASTS)) {
            this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        }
        for (int i = 0; i < this.fluidInputCounts.size(); ++i) {
            ((FluidStorageCoFH)this.inputTanks().get(i)).modify(-((Integer)this.fluidInputCounts.get(i)).intValue());
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineChillerContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }
}

