/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.MachineTileProcess;
import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachineCrucibleContainer;
import cofh.thermal.expansion.util.managers.machine.CrucibleRecipeManager;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.fluids.FluidStack;

public class MachineCrucibleTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(arg_0 -> ((CrucibleRecipeManager)CrucibleRecipeManager.instance()).validRecipe(arg_0));
    protected FluidStorageCoFH outputTank = new FluidStorageCoFH(8000);

    public MachineCrucibleTile() {
        super(TExpReferences.MACHINE_CRUCIBLE_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.outputTank, StorageGroup.OUTPUT);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = CrucibleRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack((FluidStack)this.curRecipe.getOutputFluids((IMachineInventory)this).get(0), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineCrucibleContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }

    protected boolean validateOutputs() {
        if (this.outputTank.isEmpty()) {
            return true;
        }
        FluidStack output = this.outputTank.getFluidStack();
        FluidStack recipeOutput = (FluidStack)this.curRecipe.getOutputFluids((IMachineInventory)this).get(0);
        if (this.outputTank.getSpace() < recipeOutput.getAmount()) {
            return false;
        }
        return FluidHelper.fluidsEqual((FluidStack)output, (FluidStack)recipeOutput);
    }
}

