/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.MachineTileProcess;
import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachineFurnaceContainer;
import cofh.thermal.expansion.util.managers.machine.FurnaceRecipeManager;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;

public class MachineFurnaceTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(arg_0 -> ((FurnaceRecipeManager)FurnaceRecipeManager.instance()).validRecipe(arg_0));
    protected ItemStorageCoFH outputSlot = new ItemStorageCoFH();

    public MachineFurnaceTile() {
        super(TExpReferences.MACHINE_FURNACE_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.outputSlot, StorageGroup.OUTPUT);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = FurnaceRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineFurnaceContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }

    protected boolean validateOutputs() {
        ItemStack output = this.outputSlot.getItemStack();
        if (output.func_190926_b()) {
            return true;
        }
        ItemStack recipeOutput = (ItemStack)this.curRecipe.getOutputItems((IMachineInventory)this).get(0);
        if (output.func_190916_E() >= output.func_77976_d()) {
            return false;
        }
        return ItemHelper.itemsEqualWithTags((ItemStack)output, (ItemStack)recipeOutput);
    }
}

