/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.inventory.IItemStackAccess;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.MachineTileProcess;
import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachineSmelterContainer;
import cofh.thermal.expansion.util.managers.machine.SmelterRecipeManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;

public class MachineSmelterTile
extends MachineTileProcess {
    protected ItemStorageCoFH[] inputSlots = new ItemStorageCoFH[3];
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(SmelterRecipeManager.instance()::validCatalyst);

    public MachineSmelterTile() {
        super(TExpReferences.MACHINE_SMELTER_TILE);
        this.inputSlots[0] = new ItemStorageCoFH(item -> SmelterRecipeManager.instance().validItem((ItemStack)item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()));
        this.inputSlots[1] = new ItemStorageCoFH(item -> SmelterRecipeManager.instance().validItem((ItemStack)item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()));
        this.inputSlots[2] = new ItemStorageCoFH(item -> SmelterRecipeManager.instance().validItem((ItemStack)item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()));
        for (int i = 0; i < 3; ++i) {
            this.inventory.addSlot(this.inputSlots[i], StorageGroup.INPUT);
        }
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = SmelterRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = SmelterRecipeManager.instance().getCatalyst((IItemStackAccess)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        for (int i = 0; i < 3; ++i) {
            this.inputSlots[i].modify(-((Integer)this.itemInputCounts.get(i)).intValue());
        }
        int n = decrement = this.itemInputCounts.size() > 3 ? (Integer)this.itemInputCounts.get(3) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().func_77984_f()) {
                if (this.catalystSlot.getItemStack().func_96631_a(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachineSmelterContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        List slotInputs = this.inputSlots();
        for (int i = 0; i < slotInputs.size() && i < this.itemInputCounts.size(); ++i) {
            int inputCount = (Integer)this.itemInputCounts.get(i);
            if (((ItemStorageCoFH)slotInputs.get(i)).getItemStack().func_190916_E() >= inputCount) continue;
            return false;
        }
        return true;
    }
}

