/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.thermal.core.util.managers.IManager;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.expansion.util.recipes.machine.CrafterRecipe;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class CrafterRecipeManager
implements IManager {
    private static final CrafterRecipeManager INSTANCE = new CrafterRecipeManager();
    protected static final int DEFAULT_ENERGY = 400;
    protected IdentityHashMap<IRecipe<?>, CrafterRecipe> recipeMap = new IdentityHashMap();

    public static CrafterRecipeManager instance() {
        return INSTANCE;
    }

    public boolean validItem(ItemStack item, IMachineRecipe recipe) {
        return recipe instanceof CrafterRecipe && ((CrafterRecipe)recipe).validItem(item);
    }

    public boolean validFluid(FluidStack fluid, IMachineRecipe recipe) {
        return recipe instanceof CrafterRecipe && ((CrafterRecipe)recipe).validFluid(fluid);
    }

    public CrafterRecipe getRecipe(IRecipe<?> recipe) {
        if (recipe == null || recipe.func_192399_d() || recipe.func_77571_b().func_190926_b()) {
            return null;
        }
        if (!this.recipeMap.containsKey(recipe)) {
            this.recipeMap.put(recipe, new CrafterRecipe(400, recipe));
        }
        return this.recipeMap.get(recipe);
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.recipeMap.clear();
    }
}

