/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.core.fluid.IFluidStackAccess;
import cofh.core.inventory.IItemStackAccess;
import cofh.core.util.ComparableItemStack;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.managers.AbstractManager;
import cofh.thermal.core.util.managers.IRecipeManager;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.SimpleMachineRecipe;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class PressRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final PressRecipeManager INSTANCE = new PressRecipeManager();
    protected static final int DEFAULT_ENERGY = 2400;
    protected Map<List<ComparableItemStack>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<ComparableItemStack> validInputs = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validDies = new ObjectOpenHashSet();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 1;

    public static PressRecipeManager instance() {
        return INSTANCE;
    }

    private PressRecipeManager() {
        super(2400);
    }

    public void addRecipe(ThermalRecipe recipe) {
        if (recipe.getInputItems().size() == 1) {
            for (ItemStack recipeInput : ((Ingredient)recipe.getInputItems().get(0)).func_193365_a()) {
                this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Collections.singletonList(recipeInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
            }
        } else {
            for (ItemStack dieInput : ((Ingredient)recipe.getInputItems().get(1)).func_193365_a()) {
                for (ItemStack recipeInput : ((Ingredient)recipe.getInputItems().get(0)).func_193365_a()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Arrays.asList(recipeInput, dieInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                }
            }
        }
    }

    public boolean validInput(ItemStack item) {
        return this.validInputs.contains(PressRecipeManager.convert((ItemStack)item));
    }

    public boolean validDie(ItemStack item) {
        return this.validDies.contains(PressRecipeManager.convert((ItemStack)item));
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validInputs.clear();
        this.validDies.clear();
    }

    protected ArrayList<ComparableItemStack> getKeyFromSlots(List<? extends IItemStackAccess> inputSlots) {
        ArrayList<ComparableItemStack> key = new ArrayList<ComparableItemStack>();
        for (IItemStackAccess iItemStackAccess : inputSlots) {
            if (iItemStackAccess.isEmpty()) continue;
            key.add(PressRecipeManager.convert((ItemStack)iItemStackAccess.getItemStack()));
        }
        return key;
    }

    protected ArrayList<ComparableItemStack> getKeyFromStacks(List<ItemStack> inputStacks) {
        ArrayList<ComparableItemStack> key = new ArrayList<ComparableItemStack>();
        for (ItemStack stack : inputStacks) {
            if (stack.func_190926_b()) continue;
            key.add(PressRecipeManager.convert((ItemStack)stack));
        }
        return key;
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty()) {
            return null;
        }
        return this.recipeMap.get(this.getKeyFromSlots(inputSlots));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        if (inputItems.get(0).func_190926_b()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = energy * this.getDefaultScale() / 100;
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.validInputs.add(PressRecipeManager.convert((ItemStack)inputItems.get(0)));
        if (inputItems.size() > 1 && !inputItems.get(1).func_190926_b()) {
            this.validDies.add(PressRecipeManager.convert((ItemStack)inputItems.get(1)));
        }
        this.recipeMap.put(this.getKeyFromStacks(inputItems), (IMachineRecipe)recipe);
        return recipe;
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_PRESS);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)entry.getValue());
        }
    }
}

