/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.thermal.core.util.managers.SingleItemRecipeManager;
import cofh.thermal.core.util.recipes.ThermalCatalyst;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IRecipeCatalyst;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class PulverizerRecipeManager
extends SingleItemRecipeManager.Catalyzed {
    private static final PulverizerRecipeManager INSTANCE = new PulverizerRecipeManager();
    protected static final int DEFAULT_ENERGY = 4000;

    public static PulverizerRecipeManager instance() {
        return INSTANCE;
    }

    private PulverizerRecipeManager() {
        super(4000, 4, 0);
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack input = inputItems.get(0);
        if (input.func_190926_b()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = energy * this.getDefaultScale() / 100;
        InternalPulverizerRecipe recipe = new InternalPulverizerRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(PulverizerRecipeManager.convert((ItemStack)input), recipe);
        return recipe;
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_PULVERIZER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)entry.getValue());
        }
        Map catalysts = recipeManager.func_215366_a(TExpRecipeTypes.CATALYST_PULVERIZER);
        for (Map.Entry entry : catalysts.entrySet()) {
            this.addCatalyst((ThermalCatalyst)entry.getValue());
        }
    }

    protected static class InternalPulverizerRecipe
    extends CatalyzedMachineRecipe {
        public InternalPulverizerRecipe(int energy, float experience, int minTicks, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return PulverizerRecipeManager.instance().getCatalyst(input);
        }
    }
}

