/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.core.fluid.IFluidStackAccess;
import cofh.core.inventory.IItemStackAccess;
import cofh.core.util.ComparableItemStack;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.managers.AbstractManager;
import cofh.thermal.core.util.managers.IRecipeManager;
import cofh.thermal.core.util.recipes.ThermalCatalyst;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.internal.BaseMachineCatalyst;
import cofh.thermal.core.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IRecipeCatalyst;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class SmelterRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final SmelterRecipeManager INSTANCE = new SmelterRecipeManager();
    protected static final int DEFAULT_ENERGY = 3200;
    protected Object2ObjectOpenHashMap<SmelterMapWrapper, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Map<ComparableItemStack, IRecipeCatalyst> catalystMap = new Object2ObjectOpenHashMap();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxInputItems = 3;
    protected int maxOutputItems = 4;
    protected int maxOutputFluids = 0;

    public static SmelterRecipeManager instance() {
        return INSTANCE;
    }

    private SmelterRecipeManager() {
        super(3200);
    }

    public void addRecipe(ThermalRecipe recipe) {
        switch (recipe.getInputItems().size()) {
            case 1: {
                for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).func_193365_a()) {
                    this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Collections.singletonList(firstInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                }
                return;
            }
            case 2: {
                for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).func_193365_a()) {
                    for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).func_193365_a()) {
                        this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Arrays.asList(firstInput, secondInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                    }
                }
                return;
            }
            case 3: {
                for (ItemStack firstInput : ((Ingredient)recipe.getInputItems().get(0)).func_193365_a()) {
                    for (ItemStack secondInput : ((Ingredient)recipe.getInputItems().get(1)).func_193365_a()) {
                        for (ItemStack thirdInput : ((Ingredient)recipe.getInputItems().get(2)).func_193365_a()) {
                            this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Arrays.asList(firstInput, secondInput, thirdInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
                        }
                    }
                }
                return;
            }
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(SmelterRecipeManager.convert((ItemStack)item));
    }

    protected void clear() {
        this.recipeMap.clear();
        this.catalystMap.clear();
        this.validItems.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty()) {
            return null;
        }
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(this.maxInputItems);
        for (int i = 0; i < this.maxInputItems; ++i) {
            if (inputSlots.get(i).isEmpty()) continue;
            ComparableItemStack compStack = SmelterRecipeManager.convert((ItemStack)inputSlots.get(i).getItemStack());
            convertedItems.add(compStack);
        }
        if (convertedItems.isEmpty()) {
            return null;
        }
        return (IMachineRecipe)this.recipeMap.get((Object)new SmelterMapWrapper(convertedItems));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        for (ItemStack itemStack : inputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = energy * this.getDefaultScale() / 100;
        ArrayList<ComparableItemStack> convertedItems = new ArrayList<ComparableItemStack>(inputItems.size());
        for (ItemStack stack : inputItems) {
            if (inputItems.isEmpty()) continue;
            ComparableItemStack compStack = SmelterRecipeManager.convert((ItemStack)stack);
            this.validItems.add(compStack);
            convertedItems.add(compStack);
        }
        InternalSmelterRecipe internalSmelterRecipe = new InternalSmelterRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put((Object)new SmelterMapWrapper(convertedItems), (Object)internalSmelterRecipe);
        return internalSmelterRecipe;
    }

    public List<ItemStack> getCatalysts() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(this.catalystMap.size());
        this.catalystMap.keySet().forEach(stack -> ret.add(stack.toItemStack()));
        return ret;
    }

    public IRecipeCatalyst getCatalyst(IItemStackAccess input) {
        return this.catalystMap.get(SmelterRecipeManager.convert((ItemStack)input.getItemStack()));
    }

    public IRecipeCatalyst getCatalyst(ItemStack input) {
        return this.catalystMap.get(SmelterRecipeManager.convert((ItemStack)input));
    }

    public void addCatalyst(ThermalCatalyst catalyst) {
        for (ItemStack ingredient : catalyst.getIngredient().func_193365_a()) {
            this.addCatalyst(ingredient, catalyst.getPrimaryMod(), catalyst.getSecondaryMod(), catalyst.getEnergyMod(), catalyst.getMinChance(), catalyst.getUseChance());
        }
    }

    public IRecipeCatalyst addCatalyst(ItemStack input, float primaryMod, float secondaryMod, float energyMod, float minChance, float useChance) {
        if (input == null || input.func_190926_b()) {
            return null;
        }
        BaseMachineCatalyst catalyst = new BaseMachineCatalyst(primaryMod, secondaryMod, energyMod, minChance, useChance);
        this.catalystMap.put(SmelterRecipeManager.convert((ItemStack)input), (IRecipeCatalyst)catalyst);
        return catalyst;
    }

    public boolean validCatalyst(ItemStack input) {
        return this.getCatalyst(input) != null;
    }

    public IRecipeCatalyst removeCatalyst(ItemStack input) {
        return this.catalystMap.remove(SmelterRecipeManager.convert((ItemStack)input));
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>((Collection<IMachineRecipe>)this.recipeMap.values());
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_SMELTER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)entry.getValue());
        }
        Map catalysts = recipeManager.func_215366_a(TExpRecipeTypes.CATALYST_SMELTER);
        for (Map.Entry entry : catalysts.entrySet()) {
            this.addCatalyst((ThermalCatalyst)entry.getValue());
        }
    }

    protected static class InternalSmelterRecipe
    extends CatalyzedMachineRecipe {
        public InternalSmelterRecipe(int energy, float experience, int minTicks, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(3, energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return SmelterRecipeManager.instance().getCatalyst(input);
        }
    }

    protected static class SmelterMapWrapper {
        Set<Integer> itemHashes;
        int hashCode;

        SmelterMapWrapper(List<ComparableItemStack> itemStacks) {
            this.itemHashes = new ObjectOpenHashSet(itemStacks.size());
            for (ComparableItemStack itemStack : itemStacks) {
                if (itemStack.hashCode() == 0) continue;
                this.itemHashes.add(itemStack.hashCode());
                this.hashCode += itemStack.hashCode();
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SmelterMapWrapper that = (SmelterMapWrapper)o;
            return this.itemHashes.size() == that.itemHashes.size() && this.itemHashes.containsAll(that.itemHashes);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

