/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core;

import cofh.core.client.renderer.entity.SpriteRendererCoFH;
import cofh.core.client.renderer.entity.TNTRendererCoFH;
import cofh.core.registries.DeferredRegisterCoFH;
import cofh.thermal.core.client.gui.device.DeviceHiveExtractorScreen;
import cofh.thermal.core.client.gui.device.DeviceTreeExtractorScreen;
import cofh.thermal.core.client.gui.workbench.TinkerBenchScreen;
import cofh.thermal.core.client.renderer.entity.BasalzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BasalzRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlitzRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.BlizzRenderer;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.common.ThermalFlags;
import cofh.thermal.core.init.TCoreBlocks;
import cofh.thermal.core.init.TCoreEntities;
import cofh.thermal.core.init.TCoreFluids;
import cofh.thermal.core.init.TCoreItems;
import cofh.thermal.core.init.TCoreRecipeManagers;
import cofh.thermal.core.init.TCoreRecipeSerializers;
import cofh.thermal.core.init.TCoreRecipeTypes;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.core.util.loot.TileNBTSync;
import cofh.thermal.core.world.gen.feature.ThermalFeatures;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal")
public class ThermalCore {
    public static final Logger LOG = LogManager.getLogger((String)"thermal");
    public static final DeferredRegisterCoFH<Block> BLOCKS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"thermal");
    public static final DeferredRegisterCoFH<Fluid> FLUIDS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"thermal");
    public static final DeferredRegisterCoFH<Item> ITEMS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"thermal");
    public static final DeferredRegisterCoFH<ContainerType<?>> CONTAINERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"thermal");
    public static final DeferredRegisterCoFH<EntityType<?>> ENTITIES = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"thermal");
    public static final DeferredRegisterCoFH<IRecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"thermal");
    public static final DeferredRegisterCoFH<SoundEvent> SOUND_EVENTS = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"thermal");
    public static final DeferredRegisterCoFH<TileEntityType<?>> TILE_ENTITIES = DeferredRegisterCoFH.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"thermal");

    public ThermalCore() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        BLOCKS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITIES.register(modEventBus);
        FLUIDS.register(modEventBus);
        ITEMS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        SOUND_EVENTS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ThermalConfig.register();
    }

    private void setFeatureFlags() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_NITER, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_SULFUR, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_COPPER, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_TIN, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_LEAD, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_SILVER, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RESOURCE_NICKEL, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_AREA_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_STORAGE_AUGMENTS, true);
        ThermalFlags.setFlag(ThermalFlags.FLAG_UPGRADE_AUGMENTS, true);
        ThermalFlags.setFlag("tinker_bench", true);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TCoreBlocks::setup);
        event.enqueueWork(TCoreItems::setup);
        event.enqueueWork(TCoreEntities::setup);
        event.enqueueWork(TileNBTSync::setup);
        event.enqueueWork(ThermalFeatures::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        this.registerGuiFactories();
        this.registerRenderLayers();
        this.registerEntityRenderingHandlers();
    }

    private void registerGuiFactories() {
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_HIVE_EXTRACTOR_CONTAINER, DeviceHiveExtractorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.DEVICE_TREE_EXTRACTOR_CONTAINER, DeviceTreeExtractorScreen::new);
        ScreenManager.func_216911_a(TCoreReferences.TINKER_BENCH_CONTAINER, TinkerBenchScreen::new);
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.func_228643_e_();
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("obsidian_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("signalum_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("lumium_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("enderium_glass")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("machine_frame")), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)BLOCKS.get("device_tree_extractor")), (RenderType)cutout);
    }

    private void registerEntityRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BASALZ_ENTITY, BasalzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLITZ_ENTITY, BlitzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLIZZ_ENTITY, BlizzRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BASALZ_PROJECTILE_ENTITY, BasalzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLITZ_PROJECTILE_ENTITY, BlitzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.BLIZZ_PROJECTILE_ENTITY, BlizzProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EXPLOSIVE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.PHYTO_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.FIRE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EARTH_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ICE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.LIGHTNING_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.NUKE_GRENADE_ENTITY, SpriteRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.PHYTO_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.FIRE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.EARTH_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.ICE_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.LIGHTNING_TNT_ENTITY, TNTRendererCoFH::new);
        RenderingRegistry.registerEntityRenderingHandler(TCoreReferences.NUKE_TNT_ENTITY, TNTRendererCoFH::new);
    }

    static {
        TCoreBlocks.register();
        TCoreItems.register();
        TCoreFluids.register();
        TCoreEntities.register();
        TCoreSounds.register();
        TCoreRecipeManagers.register();
        TCoreRecipeSerializers.register();
        TCoreRecipeTypes.register();
    }
}

