/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.model;

import cofh.core.client.renderer.model.BakedQuadRetextured;
import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.util.ComparableItemStack;
import cofh.core.util.control.IReconfigurable;
import cofh.thermal.core.client.gui.ThermalTextures;
import cofh.thermal.core.client.renderer.model.UnderlayBakedModel;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.ThermalTileBase;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;

public class ReconfigurableBakedModel
extends UnderlayBakedModel
implements IDynamicBakedModel {
    protected static final Int2ObjectMap<BakedQuad[]> SIDE_QUAD_CACHE = new Int2ObjectOpenHashMap();
    protected static final Int2ObjectMap<BakedQuad[]> ITEM_QUAD_CACHE = new Int2ObjectOpenHashMap();
    protected static final Map<List<Integer>, IBakedModel> MODEL_CACHE = new Object2ObjectOpenHashMap();
    private final ItemOverrideList overrideList = new ItemOverrideList(){

        @Nullable
        public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
            CompoundNBT tag = stack.func_179543_a("BlockEntityTag");
            byte[] sideConfigRaw = ReconfigurableBakedModel.getSideConfigRaw(tag);
            int itemHash = new ComparableItemStack(stack).hashCode();
            int configHash = Arrays.hashCode(sideConfigRaw);
            IBakedModel ret = MODEL_CACHE.get(Arrays.asList(itemHash, configHash));
            if (ret == null) {
                ModelUtils.WrappedBakedModelBuilder builder = new ModelUtils.WrappedBakedModelBuilder(model);
                BakedQuad[] cachedQuads = (BakedQuad[])ITEM_QUAD_CACHE.get(configHash);
                if (cachedQuads == null || cachedQuads.length < 6) {
                    cachedQuads = new BakedQuad[]{new BakedQuadRetextured((BakedQuad)builder.getQuads(Direction.DOWN).get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[0])), new BakedQuadRetextured((BakedQuad)builder.getQuads(Direction.UP).get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[1])), new BakedQuadRetextured((BakedQuad)builder.getQuads(Direction.NORTH).get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[2])), new BakedQuadRetextured((BakedQuad)builder.getQuads(Direction.SOUTH).get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[3])), new BakedQuadRetextured((BakedQuad)builder.getQuads(Direction.WEST).get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[4])), new BakedQuadRetextured((BakedQuad)builder.getQuads(Direction.EAST).get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[5]))};
                    ITEM_QUAD_CACHE.put(configHash, (Object)cachedQuads);
                }
                builder.addFaceQuad(Direction.DOWN, cachedQuads[0]);
                builder.addFaceQuad(Direction.UP, cachedQuads[1]);
                builder.addFaceQuad(Direction.NORTH, cachedQuads[2]);
                builder.addFaceQuad(Direction.SOUTH, cachedQuads[3]);
                builder.addFaceQuad(Direction.WEST, cachedQuads[4]);
                builder.addFaceQuad(Direction.EAST, cachedQuads[5]);
                ret = builder.build();
                MODEL_CACHE.put(Arrays.asList(itemHash, configHash), ret);
            }
            return ret;
        }
    };

    public static void clearCache() {
        SIDE_QUAD_CACHE.clear();
        ITEM_QUAD_CACHE.clear();
        MODEL_CACHE.clear();
    }

    public ReconfigurableBakedModel(IBakedModel originalModel) {
        super(originalModel);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        List<BakedQuad> quads = super.getQuads(state, side, rand, extraData);
        if (side == null || quads.isEmpty()) {
            return quads;
        }
        byte[] sideConfigRaw = (byte[])extraData.getData(ThermalTileBase.SIDES);
        if (sideConfigRaw == null) {
            return quads;
        }
        int sideIndex = side.func_176745_a();
        int configHash = Arrays.hashCode(sideConfigRaw);
        BakedQuad[] cachedSideQuads = (BakedQuad[])SIDE_QUAD_CACHE.get(configHash);
        if (cachedSideQuads == null || cachedSideQuads.length < 6) {
            cachedSideQuads = new BakedQuad[6];
        }
        if (cachedSideQuads[sideIndex] == null) {
            cachedSideQuads[sideIndex] = new BakedQuadRetextured(quads.get(0), ReconfigurableBakedModel.getTextureRaw(sideConfigRaw[sideIndex]));
            SIDE_QUAD_CACHE.put(configHash, (Object)cachedSideQuads);
        }
        quads.add(cachedSideQuads[sideIndex]);
        return quads;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrideList;
    }

    static TextureAtlasSprite getTexture(IReconfigurable.SideConfig[] config, int side) {
        return ReconfigurableBakedModel.getTexture(config[side]);
    }

    static TextureAtlasSprite getTexture(IReconfigurable.SideConfig side) {
        switch (side) {
            case SIDE_INPUT: {
                return ThermalTextures.MACHINE_CONFIG_INPUT;
            }
            case SIDE_OUTPUT: {
                return ThermalTextures.MACHINE_CONFIG_OUTPUT;
            }
            case SIDE_BOTH: {
                return ThermalTextures.MACHINE_CONFIG_BOTH;
            }
            case SIDE_ACCESSIBLE: {
                return ThermalTextures.MACHINE_CONFIG_ACCESSIBLE;
            }
        }
        return ThermalTextures.MACHINE_CONFIG_NONE;
    }

    static TextureAtlasSprite getTextureRaw(byte[] config, int side) {
        return ReconfigurableBakedModel.getTextureRaw(config[side]);
    }

    static TextureAtlasSprite getTextureRaw(byte side) {
        switch (side) {
            case 1: {
                return ThermalTextures.MACHINE_CONFIG_INPUT;
            }
            case 2: {
                return ThermalTextures.MACHINE_CONFIG_OUTPUT;
            }
            case 3: {
                return ThermalTextures.MACHINE_CONFIG_BOTH;
            }
            case 4: {
                return ThermalTextures.MACHINE_CONFIG_ACCESSIBLE;
            }
        }
        return ThermalTextures.MACHINE_CONFIG_NONE;
    }

    static byte[] getSideConfigRaw(CompoundNBT tag) {
        if (tag == null) {
            return ThermalConfig.DEFAULT_MACHINE_SIDES_RAW;
        }
        byte[] ret = tag.func_74770_j("Sides");
        return ret.length == 0 ? ThermalConfig.DEFAULT_MACHINE_SIDES_RAW : ret;
    }
}

