/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.common;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;

public class ThermalAugmentRules {
    private static final Set<String> ATTR_ADD = new ObjectOpenHashSet();
    private static final Set<String> ATTR_MAX = new ObjectOpenHashSet();
    private static final Set<String> ATTR_MULT = new ObjectOpenHashSet();
    private static final Set<String> ATTR_INV = new ObjectOpenHashSet();
    private static final Set<String> ATTR_INT = new ObjectOpenHashSet();
    private static final Set<String> TYPE_EXC = new ObjectOpenHashSet();
    public static final Predicate<ItemStack> DEVICE_VALIDATOR;
    public static final Predicate<ItemStack> DYNAMO_VALIDATOR;
    public static final Predicate<ItemStack> MACHINE_VALIDATOR;
    public static final Predicate<ItemStack> STORAGE_VALIDATOR;

    private ThermalAugmentRules() {
    }

    public static boolean isTypeExclusive(String type) {
        return TYPE_EXC.contains(type);
    }

    public static boolean isAdditive(String mod) {
        return ATTR_ADD.contains(mod);
    }

    public static boolean isMultiplicative(String mod) {
        return ATTR_MULT.contains(mod);
    }

    public static boolean isMaximized(String mod) {
        return ATTR_MAX.contains(mod);
    }

    public static boolean isInverse(String mod) {
        return ATTR_INV.contains(mod);
    }

    public static boolean isInteger(String mod) {
        return ATTR_INT.contains(mod);
    }

    static {
        ATTR_ADD.addAll(Arrays.asList("AEDpt", "AERad", "AERch", "DynProd", "MchPwr", "MchPri", "MchSec", "PotAmp", "PotDur"));
        ATTR_MULT.addAll(Arrays.asList("BaseMod", "RFMax", "RFXfer", "FlMax", "DynEff", "MchCat", "MchEn", "MchXp"));
        ATTR_MAX.addAll(Arrays.asList("BaseMod", "RFMax", "RFXfer", "FlMax", "MchMin"));
        ATTR_INV.addAll(Arrays.asList("MchCat", "MchEn"));
        ATTR_INT.addAll(Arrays.asList("AEDpt", "AERad", "AERch", "PotAmp"));
        TYPE_EXC.addAll(Arrays.asList("FlAug", "RFAug", "UpgAug"));
        DEVICE_VALIDATOR = e -> true;
        DYNAMO_VALIDATOR = e -> true;
        MACHINE_VALIDATOR = e -> true;
        STORAGE_VALIDATOR = e -> true;
    }
}

