/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.common;

import cofh.thermal.core.common.ThermalFlags;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ThermalConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static final byte[] DEFAULT_MACHINE_SIDES_RAW;
    public static int deviceAugments;
    public static int dynamoAugments;
    public static int machineAugments;
    public static int storageAugments;
    public static int toolAugments;
    public static boolean permanentLava;
    public static boolean permanentWater;
    public static ForgeConfigSpec.BooleanValue keepEnergy;
    public static ForgeConfigSpec.BooleanValue keepItems;
    public static ForgeConfigSpec.BooleanValue keepFluids;
    public static ForgeConfigSpec.BooleanValue keepAugments;
    public static ForgeConfigSpec.BooleanValue keepRSControl;
    public static ForgeConfigSpec.BooleanValue keepSideConfig;
    public static ForgeConfigSpec.BooleanValue keepTransferControl;
    private static ForgeConfigSpec.BooleanValue flagVanillaBlocks;
    private static ForgeConfigSpec.BooleanValue flagRockwool;
    private static ForgeConfigSpec.BooleanValue flagMobBasalz;
    private static ForgeConfigSpec.BooleanValue flagMobBlitz;
    private static ForgeConfigSpec.BooleanValue flagMobBlizz;
    private static ForgeConfigSpec.BooleanValue flagGenApatite;
    private static ForgeConfigSpec.BooleanValue flagGenCinnabar;
    private static ForgeConfigSpec.BooleanValue flagGenNiter;
    private static ForgeConfigSpec.BooleanValue flagGenSulfur;
    private static ForgeConfigSpec.BooleanValue flagGenCopper;
    private static ForgeConfigSpec.BooleanValue flagGenTin;
    private static ForgeConfigSpec.BooleanValue flagGenLead;
    private static ForgeConfigSpec.BooleanValue flagGenSilver;
    private static ForgeConfigSpec.BooleanValue flagGenNickel;
    private static ForgeConfigSpec.BooleanValue freezePermanentLava;
    private static ForgeConfigSpec.BooleanValue freezePermanentWater;
    public static boolean jeiBucketTanks;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(ThermalConfig.class);
        registered = true;
        ThermalConfig.genServerConfig();
        ThermalConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private ThermalConfig() {
    }

    private static void genServerConfig() {
        SERVER_CONFIG.push("Global Options");
        keepEnergy = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Energy when dropped.").define("Blocks Retain Energy", true);
        keepItems = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Inventory Contents when dropped.").define("Blocks Retain Inventory", false);
        keepFluids = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Tank Contents when dropped.").define("Blocks Retain Tank Contents", false);
        keepAugments = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Augments when dropped.").define("Blocks Retain Augments", true);
        keepRSControl = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Redstone Control configuration when dropped.").define("Blocks Retain Redstone Control", true);
        keepSideConfig = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Side configuration when dropped.").define("Blocks Retain Side Configuration", true);
        keepTransferControl = SERVER_CONFIG.comment("If TRUE, Thermal Blocks will retain Transfer Control configuration when dropped.").define("Blocks Retain Transfer Control", true);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Features");
        flagVanillaBlocks = SERVER_CONFIG.comment("If TRUE, various 'Vanilla+' Blocks and Recipes are enabled.").define("Vanilla+", true);
        flagRockwool = SERVER_CONFIG.comment("IF TRUE, Rockwool Blocks and Recipes are enabled.").define("Rockwool", true);
        flagMobBasalz = SERVER_CONFIG.comment("IF TRUE, the Basalz Mob is enabled.").define("Basalz", true);
        flagMobBlitz = SERVER_CONFIG.comment("IF TRUE, the Blitz Mob is enabled.").define("Blitz", true);
        flagMobBlizz = SERVER_CONFIG.comment("IF TRUE, the Blizz Mob is enabled.").define("Blizz", true);
        SERVER_CONFIG.pop();
        ThermalConfig.genWorldConfig();
        serverSpec = SERVER_CONFIG.build();
        ThermalConfig.refreshServerConfig();
    }

    private static void genClientConfig() {
        clientSpec = CLIENT_CONFIG.build();
        ThermalConfig.refreshClientConfig();
    }

    private static void genWorldConfig() {
        SERVER_CONFIG.push("World Generation");
        flagGenApatite = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Apatite from generating.").define("Apatite", true);
        flagGenCinnabar = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Cinnabar from generating.").define("Cinnabar", true);
        flagGenNiter = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Niter from generating.").define("Niter", true);
        flagGenSulfur = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Sulfur from generating.").define("Sulfur", true);
        flagGenCopper = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Copper from generating.").define("Copper", true);
        flagGenTin = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Tin from generating.").define("Tin", true);
        flagGenLead = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Lead from generating.").define("Lead", true);
        flagGenSilver = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Silver from generating.").define("Silver", true);
        flagGenNickel = SERVER_CONFIG.comment("Set to FALSE to prevent 'Thermal Series' Nickel from generating.").define("Nickel", true);
        SERVER_CONFIG.pop();
    }

    private static void genMachineConfig() {
    }

    private static void refreshServerConfig() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_VANILLA_BLOCKS, (Boolean)flagVanillaBlocks.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_ROCKWOOL, (Boolean)flagRockwool.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BASALZ, (Boolean)flagMobBasalz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLITZ, (Boolean)flagMobBlitz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLIZZ, (Boolean)flagMobBlizz.get());
        ThermalConfig.refreshWorldConfig();
    }

    private static void refreshWorldConfig() {
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_APATITE, (Boolean)flagGenApatite.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_CINNABAR, (Boolean)flagGenCinnabar.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_NITER, (Boolean)flagGenNiter.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_SULFUR, (Boolean)flagGenSulfur.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_COPPER, (Boolean)flagGenCopper.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_TIN, (Boolean)flagGenTin.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_LEAD, (Boolean)flagGenLead.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_SILVER, (Boolean)flagGenSilver.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_GEN_NICKEL, (Boolean)flagGenNickel.get());
    }

    private static void refreshClientConfig() {
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                ThermalConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                ThermalConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                ThermalConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                ThermalConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
        DEFAULT_MACHINE_SIDES_RAW = new byte[]{0, 0, 0, 0, 0, 0};
        deviceAugments = 2;
        dynamoAugments = 4;
        machineAugments = 4;
        storageAugments = 2;
        toolAugments = 4;
        permanentLava = true;
        permanentWater = true;
        jeiBucketTanks = true;
    }
}

