/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.ThermalFlags;
import cofh.thermal.core.entity.projectile.BasalzProjectileEntity;
import cofh.thermal.core.init.TCoreSounds;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BasalzEntity
extends MonsterEntity {
    private float heightOffset = 0.5f;
    private int heightOffsetUpdateTime;
    private static final DataParameter<Byte> ANGRY = EntityDataManager.func_187226_a(BasalzEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public static boolean canSpawn(EntityType<BasalzEntity> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BASALZ).getAsBoolean() && MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    public BasalzEntity(EntityType<? extends BasalzEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 2.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new BasalzAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return TCoreSounds.SOUND_BASALZ_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TCoreSounds.SOUND_BASALZ_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TCoreSounds.SOUND_BASALZ_DEATH;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K && this.isAngry() && this.field_70146_Z.nextInt(2) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218423_k, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        LivingEntity livingentity;
        --this.heightOffsetUpdateTime;
        if (this.heightOffsetUpdateTime <= 0) {
            this.heightOffsetUpdateTime = 100;
            this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((livingentity = this.func_70638_az()) != null && livingentity.func_226280_cw_() > this.func_226280_cw_() + (double)this.heightOffset && this.func_213336_c(livingentity)) {
            Vector3d vec3d = this.func_213322_ci();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vec3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ThermalCore.ITEMS.get("basalz_spawn_egg"));
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ANGRY, (Object)b0);
    }

    static class BasalzAttackGoal
    extends Goal {
        private final BasalzEntity basalz;
        private int attackStep;
        private int attackTime;
        private int chaseStep;

        public BasalzAttackGoal(BasalzEntity basalzIn) {
            this.basalz = basalzIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.basalz.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && this.basalz.func_213336_c(livingentity);
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75251_c() {
            this.basalz.setAngry(false);
            this.chaseStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity livingentity = this.basalz.func_70638_az();
            if (livingentity != null) {
                boolean flag = this.basalz.func_70635_at().func_75522_a((Entity)livingentity);
                this.chaseStep = flag ? 0 : ++this.chaseStep;
                double d0 = this.basalz.func_70068_e((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.basalz.func_70652_k((Entity)livingentity);
                    }
                    this.basalz.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.func_226277_ct_() - this.basalz.func_226277_ct_();
                    double d2 = livingentity.func_226283_e_(0.5) - this.basalz.func_226283_e_(0.5);
                    double d3 = livingentity.func_226281_cx_() - this.basalz.func_226281_cx_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                            this.basalz.setAngry(true);
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                            this.basalz.setAngry(false);
                        }
                        if (this.attackStep > 1) {
                            float f = MathHelper.func_76129_c((float)MathHelper.func_76133_a((double)d0)) * 0.5f;
                            this.basalz.field_70170_p.func_217378_a(null, 1018, this.basalz.func_233580_cy_(), 0);
                            BasalzProjectileEntity projectile = new BasalzProjectileEntity((LivingEntity)this.basalz, d1 + this.basalz.func_70681_au().nextGaussian() * (double)f, d2, d3 + this.basalz.func_70681_au().nextGaussian() * (double)f, this.basalz.field_70170_p);
                            projectile.func_70107_b(projectile.func_226277_ct_(), this.basalz.func_226283_e_(0.5) + 0.5, projectile.func_226281_cx_());
                            this.basalz.field_70170_p.func_217376_c((Entity)projectile);
                        }
                    }
                    this.basalz.func_70671_ap().func_75651_a((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.chaseStep < 5) {
                    this.basalz.func_70605_aq().func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), 1.0);
                }
                super.func_75246_d();
            }
        }

        private double getFollowDistance() {
            return this.basalz.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

