/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.core.util.Utils;
import cofh.core.util.references.CoreReferences;
import cofh.thermal.core.init.TCoreReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlitzProjectileEntity
extends DamagingProjectileEntity {
    public static float baseDamage = 7.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;

    public BlitzProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public BlitzProjectileEntity(LivingEntity shooter, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BLITZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BlitzProjectileEntity(double x, double y, double z, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BLITZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197590_A;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            if (!entity.func_190530_aW() && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.func_195064_c(new EffectInstance(CoreReferences.SHOCKED, effectDuration, effectAmplifier, false, false));
            }
            entity.func_70097_a(BlitzDamageSource.causeDamage(this, this.func_234616_v_()), entity.func_70026_G() ? baseDamage + 3.0f : baseDamage);
        }
        if (Utils.isServerWorld((World)this.field_70170_p)) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    protected static class BlitzDamageSource
    extends EntityDamageSource {
        public BlitzDamageSource(Entity source) {
            super("blitz", source);
        }

        public static DamageSource causeDamage(BlitzProjectileEntity entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("blitz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).func_76349_b();
        }
    }
}

