/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.event;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.common.ThermalAugmentRules;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="thermal")
public class TCoreClientEvents {
    private TCoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (AugmentDataHelper.hasAugmentData((ItemStack)stack)) {
            CompoundNBT augmentData = AugmentDataHelper.getAugmentData((ItemStack)stack);
            if (augmentData == null || augmentData.isEmpty()) {
                return;
            }
            String type = augmentData.func_74779_i("Type");
            if (!type.isEmpty()) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.type").func_240699_a_(TextFormatting.YELLOW).func_240702_b_(": ").func_230529_a_((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.augment.type." + type)).func_240699_a_(TextFormatting.WHITE)));
            }
            for (String mod : augmentData.func_150296_c()) {
                if (mod.equals("Type") || !StringHelper.canLocalize((String)("info.thermal.augment.attr." + mod))) continue;
                float value = augmentData.func_74760_g(mod);
                boolean bad = ThermalAugmentRules.isAdditive(mod) && value < 0.0f || ThermalAugmentRules.isAdditive(mod) && value > 0.0f && ThermalAugmentRules.isInverse(mod) || ThermalAugmentRules.isMultiplicative(mod) && (ThermalAugmentRules.isInverse(mod) ? (double)value > 1.0 : (double)value < 1.0);
                IFormattableTextComponent modText = new StringTextComponent("" + (ThermalAugmentRules.isAdditive(mod) && value > 0.0f ? "+" : "") + (ThermalAugmentRules.isInteger(mod) ? StringHelper.DF0.format(value) : (ThermalAugmentRules.isMultiplicative(mod) ? StringHelper.DF2.format(value) + "x" : StringHelper.DF0.format(value * 100.0f) + "%"))).func_240699_a_(bad ? TextFormatting.RED : TextFormatting.GREEN);
                if (ThermalAugmentRules.isMaximized(mod)) {
                    modText.func_240699_a_(TextFormatting.BOLD);
                }
                tooltip.add(StringHelper.getTextComponent((String)("info.thermal.augment.attr." + mod)).func_240702_b_(": ").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)modText));
            }
        }
    }
}

