/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.fluid;

import cofh.core.fluid.FluidCoFH;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.ThermalItemGroups;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class RedstoneFluid
extends FluidCoFH {
    protected static boolean signal = true;

    public static RedstoneFluid create(String key) {
        return new RedstoneFluid(key, "thermal:block/fluids/redstone_still", "thermal:block/fluids/redstone_flow");
    }

    protected RedstoneFluid(String key, String stillTexture, String flowTexture) {
        this.stillFluid = ThermalCore.FLUIDS.register(key, () -> new ForgeFlowingFluid.Source(this.properties));
        this.flowingFluid = ThermalCore.FLUIDS.register(RedstoneFluid.flowing((String)key), () -> new ForgeFlowingFluid.Flowing(this.properties));
        this.block = ThermalCore.BLOCKS.register(key, () -> new RedstoneFluidBlock((Supplier<? extends FlowingFluid>)this.stillFluid, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e()));
        this.bucket = ThermalCore.ITEMS.register(RedstoneFluid.bucket((String)key), () -> new BucketItem((Supplier)this.stillFluid, new Item.Properties().func_200919_a(Items.field_151133_ar).func_200917_a(1).func_200916_a(ThermalItemGroups.THERMAL_TOOLS).func_208103_a(Rarity.UNCOMMON)));
        this.properties = new ForgeFlowingFluid.Properties((Supplier)this.stillFluid, (Supplier)this.flowingFluid, FluidAttributes.builder((ResourceLocation)new ResourceLocation(stillTexture), (ResourceLocation)new ResourceLocation(flowTexture)).luminosity(7).density(1200).viscosity(1500).rarity(Rarity.UNCOMMON)).bucket((Supplier)this.bucket).block((Supplier)this.block);
    }

    public static class RedstoneFluidBlock
    extends FlowingFluidBlock {
        public RedstoneFluidBlock(Supplier<? extends FlowingFluid> supplier, AbstractBlock.Properties properties) {
            super(supplier, properties);
        }

        public boolean func_149744_f(BlockState state) {
            return signal;
        }

        public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return signal ? MathHelper.clamp((int)((Integer)blockState.func_177229_b((Property)field_176367_b) * 2 - 1), (int)1, (int)15) : 0;
        }
    }
}

