/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.init;

import cofh.core.block.GunpowderBlock;
import cofh.core.block.HardenedGlassBlock;
import cofh.core.block.OreBlockCoFH;
import cofh.core.block.RubberBlock;
import cofh.core.block.TNTBlockCoFH;
import cofh.core.block.TileBlock4Way;
import cofh.core.block.storage.MetalStorageBlock;
import cofh.core.item.BlockItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.BlockHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.common.ThermalFlags;
import cofh.thermal.core.common.ThermalItemGroups;
import cofh.thermal.core.entity.item.EarthTNTEntity;
import cofh.thermal.core.entity.item.FireTNTEntity;
import cofh.thermal.core.entity.item.IceTNTEntity;
import cofh.thermal.core.entity.item.LightningTNTEntity;
import cofh.thermal.core.entity.item.NukeTNTEntity;
import cofh.thermal.core.entity.item.PhytoTNTEntity;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.device.DeviceHiveExtractorContainer;
import cofh.thermal.core.inventory.container.device.DeviceTreeExtractorContainer;
import cofh.thermal.core.inventory.container.workbench.TinkerBenchContainer;
import cofh.thermal.core.tileentity.device.DeviceHiveExtractorTile;
import cofh.thermal.core.tileentity.device.DeviceTreeExtractorTile;
import cofh.thermal.core.tileentity.workbench.TinkerBenchTile;
import cofh.thermal.core.util.RegistrationHelper;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.extensions.IForgeContainerType;

public class TCoreBlocks {
    private TCoreBlocks() {
    }

    public static void register() {
        TCoreBlocks.registerVanilla();
        TCoreBlocks.registerResources();
        TCoreBlocks.registerStorage();
        TCoreBlocks.registerBuildingBlocks();
        TCoreBlocks.registerMisc();
        TCoreBlocks.registerTileBlocks();
        TCoreBlocks.registerTileContainers();
        TCoreBlocks.registerTileEntities();
    }

    public static void setup() {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("charcoal_block"), 5, 5);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("gunpowder_block"), 15, 100);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("sugar_cane_block"), 60, 20);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("bamboo_block"), 60, 20);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("sawdust_block"), 10, 10);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("rosin_block"), 5, 5);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("phyto_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
    }

    private static void registerVanilla() {
        RegistrationHelper.registerBlockAndItem("charcoal_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185851_d)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("charcoal_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(16000).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS)));
        RegistrationHelper.registerBlock("gunpowder_block", () -> new GunpowderBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h)), ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("sugar_cane_block", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151669_i).func_200943_b(1.0f).func_200947_a(SoundType.field_222472_s)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.6f);
            }
        }, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("bamboo_block", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151669_i).func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.8f);
            }
        }, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("apple_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)), ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("carrot_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193562_N).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)), ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("potato_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193573_Y).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)), ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("beetroot_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193559_aa).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)), ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
    }

    private static void registerResources() {
        RegistrationHelper.registerBlock("apatite_ore", () -> new OreBlockCoFH(1).xp(0, 2));
        RegistrationHelper.registerBlock("cinnabar_ore", () -> new OreBlockCoFH(1).xp(0, 2));
        RegistrationHelper.registerBlock("niter_ore", () -> new OreBlockCoFH(1).xp(0, 2));
        RegistrationHelper.registerBlock("sulfur_ore", () -> new OreBlockCoFH(1).xp(0, 2));
        RegistrationHelper.registerBlock("copper_ore", () -> new OreBlockCoFH(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER));
        RegistrationHelper.registerBlock("tin_ore", () -> new OreBlockCoFH(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock("lead_ore", () -> new OreBlockCoFH(2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock("silver_ore", () -> new OreBlockCoFH(2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock("nickel_ore", () -> new OreBlockCoFH(2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock("ruby_ore", () -> new OreBlockCoFH(2).xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock("sapphire_ore", () -> new OreBlockCoFH(2).xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
    }

    private static void registerStorage() {
        RegistrationHelper.registerBlock("apatite_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193564_P).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d)));
        RegistrationHelper.registerBlock("cinnabar_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193559_aa).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d)));
        RegistrationHelper.registerBlock("niter_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193561_M).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d)));
        RegistrationHelper.registerBlock("sulfur_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193565_Q).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d)){

            public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
                return side == Direction.UP;
            }
        });
        RegistrationHelper.registerBlock("copper_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER));
        RegistrationHelper.registerBlock("tin_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock("lead_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock("silver_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock("nickel_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock("bronze_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_BRONZE));
        RegistrationHelper.registerBlock("electrum_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_ELECTRUM));
        RegistrationHelper.registerBlock("invar_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_INVAR));
        RegistrationHelper.registerBlock("constantan_block", () -> new MetalStorageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CONSTANTAN));
        RegistrationHelper.registerBlock("signalum_block", () -> new MetalStorageBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151645_D).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235838_a_(BlockHelper.lightValue((int)7)).func_226896_b_()){

            public boolean func_149744_f(BlockState state) {
                return true;
            }

            public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
                return 15;
            }
        }, Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("lumium_block", () -> new MetalStorageBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151673_t).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235838_a_(BlockHelper.lightValue((int)15)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("enderium_block", () -> new MetalStorageBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(25.0f, 30.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(2).harvestTool(ToolType.PICKAXE).func_235838_a_(BlockHelper.lightValue((int)3)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("ruby_block", () -> new MetalStorageBlock(MaterialColor.field_151645_D, 1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock("sapphire_block", () -> new MetalStorageBlock(MaterialColor.field_151649_A, 1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
        RegistrationHelper.registerBlockAndItem("sawdust_block", () -> new FallingBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 1.0f).func_200947_a(SoundType.field_185855_h)){

            @OnlyIn(value=Dist.CLIENT)
            public int getDustColor(BlockState state) {
                return 11507581;
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("sawdust_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400));
        RegistrationHelper.registerBlockAndItem("rosin_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151676_q).func_200948_a(2.0f, 4.0f).func_226897_b_(0.8f).func_226898_c_(0.8f).func_200947_a(SoundType.field_226947_m_)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.8f);
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("rosin_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(8000));
        RegistrationHelper.registerBlock("rubber_block", () -> new RubberBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_193561_M).func_200948_a(3.0f, 3.0f).func_226898_c_(1.25f).func_200947_a(SoundType.field_185849_b)));
        RegistrationHelper.registerBlock("cured_rubber_block", () -> new RubberBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(3.0f, 3.0f).func_226898_c_(1.25f).func_200947_a(SoundType.field_185849_b)));
        RegistrationHelper.registerBlock("slag_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d)));
        RegistrationHelper.registerBlock("rich_slag_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d)));
    }

    private static void registerBuildingBlocks() {
        RegistrationHelper.registerBlock("machine_frame", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(2.0f).func_226896_b_()), ThermalFlags.getFlag("machine_frame"));
        RegistrationHelper.registerBlock("obsidian_glass", () -> new HardenedGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151654_J).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_()));
        RegistrationHelper.registerBlock("signalum_glass", () -> new HardenedGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151645_D).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(BlockHelper.lightValue((int)7)).func_226896_b_()){

            public boolean func_149744_f(BlockState state) {
                return true;
            }

            public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
                return 15;
            }
        }, Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("lumium_glass", () -> new HardenedGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151673_t).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(BlockHelper.lightValue((int)15)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("enderium_glass", () -> new HardenedGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(BlockHelper.lightValue((int)3)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("white_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151666_j).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("orange_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151676_q).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("magenta_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151675_r).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("light_blue_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151674_s).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("yellow_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151673_t).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("lime_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151672_u).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("pink_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151671_v).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("gray_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151670_w).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("light_gray_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("cyan_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("purple_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151678_z).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("blue_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151649_A).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("brown_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151650_B).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("green_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151651_C).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("red_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151645_D).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("black_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
    }

    private static void registerMisc() {
        RegistrationHelper.registerBlock("phyto_tnt", () -> new TNTBlockCoFH(PhytoTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalFlags.getFlag(ThermalFlags.FLAG_PHYTOGRO_EXPLOSIVES));
        RegistrationHelper.registerBlock("fire_tnt", () -> new TNTBlockCoFH(FireTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("earth_tnt", () -> new TNTBlockCoFH(EarthTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151654_J).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("ice_tnt", () -> new TNTBlockCoFH(IceTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151657_g).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("lightning_tnt", () -> new TNTBlockCoFH(LightningTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("nuke_tnt", () -> new TNTBlockCoFH(NukeTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_193566_R).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), Rarity.UNCOMMON, ThermalFlags.getFlag(ThermalFlags.FLAG_NUCLEAR_EXPLOSIVES));
    }

    private static void registerTileBlocks() {
        IntSupplier deviceAugs = () -> ThermalConfig.deviceAugments;
        Predicate<ItemStack> deviceValidator = e -> true;
        RegistrationHelper.registerAugBlock("device_hive_extractor", () -> new TileBlock4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(2.5f), DeviceHiveExtractorTile::new), deviceAugs, deviceValidator, ThermalFlags.getFlag("device_hive_extractor"));
        RegistrationHelper.registerAugBlock("device_tree_extractor", () -> new TileBlock4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(2.5f), DeviceTreeExtractorTile::new), deviceAugs, deviceValidator, ThermalFlags.getFlag("device_tree_extractor"));
        IntSupplier workbenchAugs = () -> ThermalConfig.storageAugments;
        Predicate<ItemStack> workbenchValidator = e -> true;
        RegistrationHelper.registerAugBlock("tinker_bench", () -> new TileBlock4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200943_b(2.5f), TinkerBenchTile::new), workbenchAugs, workbenchValidator, ThermalFlags.getFlag("tinker_bench"));
    }

    private static void registerTileContainers() {
        ThermalCore.CONTAINERS.register("device_hive_extractor", () -> IForgeContainerType.create((windowId, inv, data) -> new DeviceHiveExtractorContainer(windowId, ProxyUtils.getClientWorld(), data.func_179259_c(), inv, ProxyUtils.getClientPlayer())));
        ThermalCore.CONTAINERS.register("device_tree_extractor", () -> IForgeContainerType.create((windowId, inv, data) -> new DeviceTreeExtractorContainer(windowId, ProxyUtils.getClientWorld(), data.func_179259_c(), inv, ProxyUtils.getClientPlayer())));
        ThermalCore.CONTAINERS.register("tinker_bench", () -> IForgeContainerType.create((windowId, inv, data) -> new TinkerBenchContainer(windowId, ProxyUtils.getClientWorld(), data.func_179259_c(), inv, ProxyUtils.getClientPlayer())));
    }

    private static void registerTileEntities() {
        ThermalCore.TILE_ENTITIES.register("device_hive_extractor", () -> TileEntityType.Builder.func_223042_a(DeviceHiveExtractorTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_HIVE_EXTRACTOR_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_tree_extractor", () -> TileEntityType.Builder.func_223042_a(DeviceTreeExtractorTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_TREE_EXTRACTOR_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("tinker_bench", () -> TileEntityType.Builder.func_223042_a(TinkerBenchTile::new, (Block[])new Block[]{TCoreReferences.TINKER_BENCH_BLOCK}).func_206865_a(null));
    }
}

