/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.IMultiModeItem;
import cofh.core.item.ItemCoFH;
import cofh.core.key.CoreKeys;
import cofh.core.util.ChatHelper;
import cofh.core.util.ProxyUtils;
import cofh.core.util.Utils;
import cofh.core.util.helpers.KeyHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DetonatorItem
extends ItemCoFH
implements IMultiModeItem {
    protected static final Map<Block, ITNTFactory<? extends TNTEntity>> TNT_MAP = new IdentityHashMap<Block, ITNTFactory<? extends TNTEntity>>();
    protected static final int MAX_PRIMED = 16;

    public static void registerTNT(Block block, ITNTFactory<? extends TNTEntity> factory) {
        if (block == null) {
            return;
        }
        TNT_MAP.put(block, factory);
    }

    public DetonatorItem(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("primed"), (stack, world, living) -> this.getMode(stack) == 0 && this.getPrimedCount(stack) > 0 ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("armed"), (stack, world, living) -> this.getMode(stack) == 1 && this.getPrimedCount(stack) > 0 ? 1.0f : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.detonator.use." + this.getMode(stack))).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.detonator.primed").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)StringHelper.getTextComponent((String)(" " + this.getPrimedCount(stack) + "/" + 16)).func_240699_a_(this.getPrimedCount(stack) <= 0 ? TextFormatting.RED : (this.getMode(stack) == 0 ? TextFormatting.YELLOW : TextFormatting.GREEN))));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.thermal.detonator.use.sneak").func_240699_a_(TextFormatting.DARK_GRAY));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.detonator.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        if (this.getPrimedCount(stack) > 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.mode_change", new Object[]{KeyHelper.getKeynameFromKeycode((int)CoreKeys.MULTIMODE_INCREMENT.getKey().func_197937_c())}).func_240699_a_(TextFormatting.YELLOW));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    protected boolean useDelegate(ItemStack stack, ItemUseContext context) {
        if (this.getMode(stack) == 0) {
            return this.primeTNT(stack, context.func_195991_k(), context.func_195995_a(), context.func_195999_j());
        }
        return this.detonateTNT(stack, context.func_195991_k(), context.func_195999_j());
    }

    protected boolean primeTNT(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        if (player == null || world.func_175623_d(pos)) {
            return false;
        }
        if (TNT_MAP.containsKey(world.func_180495_p(pos).func_177230_c())) {
            ListNBT primedTNT = stack.func_196082_o().func_150295_c("Primed", 10);
            CompoundNBT tntPos = NBTUtil.func_186859_a((BlockPos)pos);
            if (primedTNT.size() >= 16 || primedTNT.contains((Object)tntPos)) {
                return false;
            }
            primedTNT.add((Object)tntPos);
            stack.func_196082_o().func_218657_a("Primed", (INBT)primedTNT);
            return true;
        }
        return false;
    }

    protected boolean detonateTNT(ItemStack stack, World world, PlayerEntity player) {
        if (player == null) {
            return false;
        }
        if (Utils.isServerWorld((World)world)) {
            ListNBT primedTNT = stack.func_196082_o().func_150295_c("Primed", 10);
            for (int i = 0; i < primedTNT.size(); ++i) {
                BlockPos tntPos = NBTUtil.func_186861_c((CompoundNBT)primedTNT.func_150305_b(i));
                this.attemptDetonate(world, tntPos, player, 0);
            }
            stack.func_196083_e("Primed");
        }
        this.setMode(stack, 0);
        return true;
    }

    protected void attemptDetonate(World world, BlockPos pos, PlayerEntity player, int fuse) {
        if (!world.func_195588_v(pos)) {
            return;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (TNT_MAP.containsKey(block)) {
            world.func_217377_a(pos, false);
            TNTEntity tnt = TNT_MAP.get(block).createTNT(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (LivingEntity)player);
            tnt.func_184534_a(fuse);
            world.func_217376_c((Entity)tnt);
            world.func_184148_a(null, tnt.func_226277_ct_(), tnt.func_226278_cu_(), tnt.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    protected int getPrimedCount(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        ListNBT primedTNT = stack.func_77978_p().func_150295_c("Primed", 10);
        return primedTNT.size();
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), context.func_195996_i()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        return player.func_175151_a(context.func_195995_a(), context.func_196000_l(), stack) && this.useDelegate(stack, context) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_226563_dT_()) {
            stack.func_196083_e("Primed");
            player.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 0.3f);
            return ActionResult.func_226248_a_((Object)stack);
        }
        if (this.getMode(stack) == 1 && this.detonateTNT(stack, world, player)) {
            player.func_184609_a(hand);
            player.func_184185_a(SoundEvents.field_187750_dc, 0.4f, 1.0f);
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public int getNumModes(ItemStack stack) {
        return this.getPrimedCount(stack) > 0 ? 2 : 1;
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.4f, 1.0f - 0.3f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.detonator.mode." + this.getMode(stack)));
    }

    public static interface ITNTFactory<T extends TNTEntity> {
        public T createTNT(World var1, double var2, double var4, double var6, LivingEntity var8);
    }
}

