/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.Utils;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DeadCoralWallFanBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class PhytoGroItem
extends ItemCoFH {
    protected static final int CLOUD_DURATION = 20;
    protected int strength = 4;

    public PhytoGroItem(Item.Properties builder) {
        super(builder);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        if (PhytoGroItem.attemptGrowPlant(world, pos = context.func_195995_a(), context, this.strength)) {
            if (!world.field_72995_K) {
                world.func_217379_c(2005, pos, 0);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected static boolean attemptGrowPlant(World world, BlockPos pos, ItemUseContext context, int strength) {
        int hook;
        ItemStack stack = context.func_195996_i();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = context.func_195999_j();
        if (player != null && (hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)world, (BlockPos)pos, (BlockState)state, (ItemStack)stack)) != 0) {
            return hook > 0;
        }
        boolean used = PhytoGroItem.growPlant(world, pos, state, strength);
        if (Utils.isServerWorld((World)world) && (used |= PhytoGroItem.growSeagrass(world, pos, context.func_196000_l()))) {
            stack.func_190918_g(1);
        }
        return used;
    }

    protected static boolean growPlant(World worldIn, BlockPos pos, BlockState state, int strength) {
        if (state.func_177230_c() instanceof IGrowable) {
            IGrowable growable = (IGrowable)state.func_177230_c();
            boolean used = false;
            for (int i = 0; i < strength; ++i) {
                block5: {
                    if (!growable.func_176473_a((IBlockReader)worldIn, pos, state, worldIn.field_72995_K)) continue;
                    if (worldIn instanceof ServerWorld && growable.func_180670_a(worldIn, worldIn.field_73012_v, pos, state)) {
                        try {
                            growable.func_225535_a_((ServerWorld)worldIn, worldIn.field_73012_v, pos, state);
                        }
                        catch (Exception e) {
                            if (growable instanceof BambooBlock) break block5;
                            throw e;
                        }
                    }
                }
                used = true;
            }
            return used;
        }
        return false;
    }

    public static boolean growSeagrass(World worldIn, BlockPos pos, @Nullable Direction side) {
        if (worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(pos).func_206882_g() == 8) {
            if (!(worldIn instanceof ServerWorld)) {
                return true;
            }
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                BlockState blockstate = Blocks.field_203198_aQ.func_176223_P();
                for (int j = 0; j < i / 16; ++j) {
                    if (worldIn.func_180495_p(blockpos = blockpos.func_177982_a(field_77697_d.nextInt(3) - 1, (field_77697_d.nextInt(3) - 1) * field_77697_d.nextInt(3) / 2, field_77697_d.nextInt(3) - 1)).func_235785_r_((IBlockReader)worldIn, blockpos)) continue block0;
                }
                Optional optional = worldIn.func_242406_i(blockpos);
                if (Objects.equals(optional, Optional.of(Biomes.field_203614_T)) || Objects.equals(optional, Optional.of(Biomes.field_203617_W))) {
                    if (i == 0 && side != null && side.func_176740_k().func_176722_c()) {
                        blockstate = (BlockState)((Block)BlockTags.field_211922_B.func_205596_a(worldIn.field_73012_v)).func_176223_P().func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)side);
                    } else if (field_77697_d.nextInt(4) == 0) {
                        blockstate = ((Block)BlockTags.field_212741_H.func_205596_a(field_77697_d)).func_176223_P();
                    }
                }
                if (blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_211922_B)) {
                    for (int k = 0; !blockstate.func_196955_c((IWorldReader)worldIn, blockpos) && k < 4; ++k) {
                        blockstate = (BlockState)blockstate.func_206870_a((Property)DeadCoralWallFanBlock.field_211884_b, (Comparable)Direction.Plane.HORIZONTAL.func_179518_a(field_77697_d));
                    }
                }
                if (!blockstate.func_196955_c((IWorldReader)worldIn, blockpos)) continue;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_203425_a(Blocks.field_150355_j) && worldIn.func_204610_c(blockpos).func_206882_g() == 8) {
                    worldIn.func_180501_a(blockpos, blockstate, 3);
                    continue;
                }
                if (!blockstate1.func_203425_a(Blocks.field_203198_aQ) || field_77697_d.nextInt(10) != 0) continue;
                ((IGrowable)Blocks.field_203198_aQ).func_225535_a_((ServerWorld)worldIn, field_77697_d, blockpos, blockstate1);
            }
            return true;
        }
        return false;
    }

    protected static void makeAreaOfEffectCloud(World world, BlockPos pos, int radius) {
        boolean isPlant = world.func_180495_p(pos).func_177230_c() instanceof IPlantable;
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + (isPlant ? 0.0 : 1.0), (double)pos.func_177952_p() + 0.5);
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197632_y);
        cloud.func_184486_b(20);
        cloud.func_184485_d(0);
        cloud.func_184487_c(((float)(1 + radius) - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        world.func_217376_c((Entity)cloud);
    }
}

