/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.plugins.jei;

import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.util.recipes.ThermalCatalyst;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ThermalCatalystCategory<T extends ThermalCatalyst>
implements IRecipeCategory<T> {
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected ITextComponent name;
    protected IDrawableStatic slot;

    public ThermalCatalystCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        this.background = guiHelper.drawableBuilder(Drawables.JEI_TEXTURE, 26, 11, 140, 62).addPadding(0, 0, 16, 8).build();
        this.slot = Drawables.getDrawables(guiHelper).getSlot(0);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.name.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(T recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(((ThermalCatalyst)((Object)recipe)).getIngredient()));
    }

    public void setRecipe(IRecipeLayout layout, T recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 16, 22);
        guiItemStacks.set(0, (List)inputs.get(0));
    }

    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.slot.draw(matrixStack, 16, 22);
        Minecraft minecraft = Minecraft.func_71410_x();
        String primaryMod = StringHelper.localize((String)"info.thermal.primary_mod") + ": " + ((ThermalCatalyst)((Object)recipe)).getPrimaryMod() + "x";
        minecraft.field_71466_p.func_238421_b_(matrixStack, primaryMod, 44.0f, 8.0f, -10461088);
        String secondaryMod = StringHelper.localize((String)"info.thermal.secondary_mod") + ": " + ((ThermalCatalyst)((Object)recipe)).getSecondaryMod() + "x";
        minecraft.field_71466_p.func_238421_b_(matrixStack, secondaryMod, 44.0f, 20.0f, -10461088);
        String energyMod = StringHelper.localize((String)"info.thermal.energy_mod") + ": " + ((ThermalCatalyst)((Object)recipe)).getEnergyMod() + "x";
        minecraft.field_71466_p.func_238421_b_(matrixStack, energyMod, 44.0f, 32.0f, -10461088);
        String useChance = StringHelper.localize((String)"info.thermal.use_chance") + ": " + StringHelper.DF0.format(((ThermalCatalyst)((Object)recipe)).getUseChance() * 100.0f) + "%";
        minecraft.field_71466_p.func_238421_b_(matrixStack, useChance, 44.0f, 44.0f, -10461088);
    }
}

