/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.plugins.jei;

import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ThermalRecipeCategory<T extends ThermalRecipe>
implements IRecipeCategory<T> {
    protected final int ENERGY_X = 2;
    protected final int ENERGY_Y = 10;
    protected final ResourceLocation uid;
    protected IDrawable background;
    protected IDrawable icon;
    protected ITextComponent name;
    protected IDrawableStatic energyBackground;
    protected IDrawableStatic progressBackground;
    protected IDrawableStatic progressFluidBackground;
    protected IDrawableStatic speedBackground;
    protected IDrawableAnimated energy;
    protected IDrawableAnimated progress;
    protected IDrawableAnimated progressFluid;
    protected IDrawableAnimated speed;

    public ThermalRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        this(guiHelper, icon, uid, true);
    }

    public ThermalRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid, boolean drawEnergy) {
        this.uid = uid;
        this.icon = guiHelper.createDrawableIngredient((Object)icon);
        if (drawEnergy) {
            this.energyBackground = Drawables.getDrawables(guiHelper).getEnergyEmpty();
            this.energy = guiHelper.createAnimatedDrawable(Drawables.getDrawables(guiHelper).getEnergyFill(), 400, IDrawableAnimated.StartDirection.TOP, true);
        }
    }

    protected void addDefaultItemTooltipCallback(IGuiItemStackGroup group, List<Float> chances, int indexOffset) {
        group.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!chances.isEmpty() && slotIndex >= indexOffset && slotIndex < indexOffset + chances.size()) {
                float chance = Math.abs(((Float)chances.get(slotIndex - indexOffset)).floatValue());
                if (chance < 1.0f) {
                    tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance").func_240702_b_(": " + (int)(100.0f * chance) + "%"));
                } else if ((chance -= (float)((int)chance)) > 0.0f) {
                    tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance_additional").func_240702_b_(": " + (int)(100.0f * chance) + "%"));
                }
            }
        });
    }

    protected void addCatalyzedItemTooltipCallback(IGuiItemStackGroup group, List<Float> chances, int indexOffset) {
        group.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == indexOffset - 1) {
                tooltip.add(StringHelper.getTextComponent((String)"info.cofh.optional_catalyst"));
            } else if (!chances.isEmpty() && slotIndex >= indexOffset && slotIndex < indexOffset + chances.size()) {
                float chance = Math.abs(((Float)chances.get(slotIndex - indexOffset)).floatValue());
                if (chance < 1.0f) {
                    tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance").func_240702_b_(": " + (int)(100.0f * chance) + "%"));
                } else if ((chance -= (float)((int)chance)) > 0.0f) {
                    tooltip.add(StringHelper.getTextComponent((String)"info.cofh.chance_additional").func_240702_b_(": " + (int)(100.0f * chance) + "%"));
                }
            }
        });
    }

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.name.getString();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        if (this.energyBackground != null) {
            this.energyBackground.draw(matrixStack, 2, 10);
        }
        if (this.energy != null) {
            this.energy.draw(matrixStack, 2, 10);
        }
    }

    public List<ITextComponent> getTooltipStrings(T recipe, double mouseX, double mouseY) {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (this.energy != null && mouseX > 2.0 && mouseX < (double)(2 + this.energy.getWidth() - 1) && mouseY > 10.0 && mouseY < (double)(10 + this.energy.getHeight() - 1)) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.energy").func_240702_b_(": " + StringHelper.format((long)((ThermalRecipe)((Object)recipe)).getEnergy()) + " RF"));
        }
        return tooltip;
    }
}

