/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity;

import cofh.core.energy.EnergyStorageCoFH;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.tileentity.ThermalTileBase;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class DynamoTileBase
extends ThermalTileBase
implements ITickableTileEntity {
    protected static final int BASE_PROCESS_TICK = 40;
    protected Direction facing;
    protected int fuel;
    protected int fuelMax;
    protected int coolant;
    protected int coolantMax;
    protected int baseProcessTick;
    protected int processTick;
    protected int minProcessTick;
    protected float processMod;
    protected float energyMod;

    public DynamoTileBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.processTick = this.baseProcessTick = this.getBaseProcessTick();
        this.minProcessTick = this.processTick / 10;
        this.processMod = 1.0f;
        this.energyMod = 1.0f;
        this.energyStorage = new EnergyStorageCoFH(this.getBaseEnergyStorage(), 0, this.getBaseEnergyXfer());
    }

    @Override
    protected int getBaseEnergyStorage() {
        return 4000;
    }

    @Override
    protected int getBaseProcessTick() {
        return 40;
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        this.facing = (Direction)state.func_177229_b((Property)Constants.FACING_ALL);
        return this;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateFacing();
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            this.processTick();
            if (this.canProcessFinish()) {
                this.processFinish();
                if (!this.redstoneControl.getState() || !this.canProcessStart()) {
                    this.processOff();
                } else {
                    this.processStart();
                }
            }
        } else if (this.timeCheckQuarter()) {
            if (this.redstoneControl.getState() && this.canProcessStart()) {
                this.processStart();
                this.processTick();
                this.isActive = true;
            } else {
                this.energyStorage.modify(-this.minProcessTick);
            }
        }
        this.updateActiveState(curActive);
    }

    protected abstract boolean canProcessStart();

    protected boolean canProcessFinish() {
        return this.fuel <= 0;
    }

    protected abstract void processStart();

    protected void processFinish() {
    }

    protected void processOff() {
        this.isActive = false;
        this.wasActive = true;
        if (this.field_145850_b != null) {
            this.timeTracker.markTime(this.field_145850_b);
        }
    }

    protected int processTick() {
        if (this.fuel <= 0) {
            return 0;
        }
        int energy = this.calcEnergy();
        this.energyStorage.modify(energy);
        this.fuel -= energy;
        this.transferRF();
        return energy;
    }

    protected int calcEnergy() {
        return Math.min(this.processTick, this.minProcessTick + (int)((double)this.processTick * (1.0 - this.energyStorage.getRatio())));
    }

    protected void transferRF() {
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (Direction)this.getFacing());
        Direction opposite = this.getFacing().func_176734_d();
        if (adjTile != null) {
            int maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            adjTile.getCapability(CapabilityEnergy.ENERGY, opposite).ifPresent(e -> this.energyStorage.modify(-e.receiveEnergy(maxTransfer, false)));
        }
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            this.updateFacing();
        }
        return this.facing;
    }

    protected void updateFacing() {
        this.facing = (Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_ALL);
    }

    @Override
    public int getCurSpeed() {
        return this.isActive ? this.calcEnergy() : 0;
    }

    @Override
    public int getMaxSpeed() {
        return this.baseProcessTick;
    }

    @Override
    public double getEfficiency() {
        if (this.getEnergyMod() <= 0.0f) {
            return Double.MIN_VALUE;
        }
        return this.getEnergyMod();
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.fuelMax <= 0 || this.fuel <= 0) {
            return 0;
        }
        return scale * this.fuel / this.fuelMax;
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeInt(this.fuelMax);
        buffer.writeInt(this.fuel);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.fuelMax = buffer.readInt();
        this.fuel = buffer.readInt();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.fuelMax = nbt.func_74762_e("FuelMax");
        this.fuel = nbt.func_74762_e("Fuel");
        this.coolantMax = nbt.func_74762_e("CoolantMax");
        this.coolant = nbt.func_74762_e("Coolant");
        this.processTick = nbt.func_74762_e("ProcTick");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.fuelMax);
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("CoolantMax", this.coolantMax);
        nbt.func_74768_a("Coolant", this.coolant);
        nbt.func_74768_a("ProcTick", this.processTick);
        return nbt;
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.processMod = 1.0f;
        this.energyMod = 1.0f;
    }

    @Override
    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.processMod += this.getAttributeMod(augmentData, "DynProd");
        this.energyMod *= this.getAttributeModWithDefault(augmentData, "DynEff", 1.0f);
    }

    @Override
    protected void finalizeAttributes() {
        super.finalizeAttributes();
        float scaleMin = Constants.AUG_SCALE_MIN;
        float scaleMax = Constants.AUG_SCALE_MAX;
        this.baseProcessTick = Math.round((float)this.getBaseProcessTick() * this.baseMod * this.processMod);
        this.energyMod = MathHelper.clamp((float)this.energyMod, (float)scaleMin, (float)scaleMax);
        this.processTick = this.baseProcessTick;
        this.minProcessTick = this.baseProcessTick / 10;
    }

    protected final float getEnergyMod() {
        return this.energyMod;
    }

    @Override
    protected float getEnergyStorageMod() {
        return this.baseMod * this.processMod;
    }

    @Override
    protected float getEnergyXferMod() {
        return this.baseMod * this.processMod;
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        if (!this.itemCap.isPresent()) {
            this.itemCap = LazyOptional.of(() -> this.inventory.getHandler(StorageGroup.ACCESSIBLE));
        }
        return this.itemCap.cast();
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side != null && side.equals((Object)this.getFacing())) {
            return LazyOptional.empty();
        }
        if (!this.fluidCap.isPresent()) {
            this.fluidCap = LazyOptional.of(() -> this.tankInv.getHandler(StorageGroup.ACCESSIBLE));
        }
        return this.fluidCap.cast();
    }
}

