/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity;

import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.constants.Constants;
import cofh.core.util.control.IReconfigurable;
import cofh.core.util.control.IReconfigurableTile;
import cofh.core.util.control.ITransferControllableTile;
import cofh.core.util.control.ReconfigControlModule;
import cofh.core.util.control.TransferControlModule;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.thermal.core.tileentity.ThermalTileBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public abstract class ReconfigurableTile4Way
extends ThermalTileBase
implements IReconfigurableTile,
ITransferControllableTile {
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, EnergyHelper::hasEnergyHandlerCap);
    protected int inputTracker;
    protected int outputTracker;
    protected ReconfigControlModule reconfigControl = new ReconfigControlModule((IReconfigurableTile)this);
    protected TransferControlModule transferControl = new TransferControlModule((ITransferControllableTile)this);
    protected final LazyOptional<?>[] sidedItemCaps = new LazyOptional[]{LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty()};
    protected final LazyOptional<?>[] sidedFluidCaps = new LazyOptional[]{LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty()};

    public ReconfigurableTile4Way(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TileCoFH worldContext(BlockState state, IBlockReader world) {
        this.reconfigControl.setFacing((Direction)state.func_177229_b((Property)Constants.FACING_HORIZONTAL));
        this.updateSidedHandlers();
        return this;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.updateSideCache();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<?> handler : this.sidedItemCaps) {
            handler.invalidate();
        }
        for (LazyOptional<?> handler : this.sidedFluidCaps) {
            handler.invalidate();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(SIDES, (Object)this.reconfigControl().getRawSideConfig()).withInitial(FLUID, (Object)this.renderFluid).build();
    }

    protected void updateSideCache() {
        Direction curFacing;
        Direction prevFacing = this.getFacing();
        if (prevFacing != (curFacing = (Direction)this.func_195044_w().func_177229_b((Property)Constants.FACING_HORIZONTAL))) {
            this.reconfigControl.setFacing(curFacing);
            int iPrev = prevFacing.func_176745_a();
            int iFace = curFacing.func_176745_a();
            IReconfigurable.SideConfig[] sides = new IReconfigurable.SideConfig[6];
            if (iPrev == BlockHelper.SIDE_RIGHT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_CLOCK_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_LEFT[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.ROTATE_COUNTER_Y[i]];
                }
            } else if (iPrev == BlockHelper.SIDE_OPPOSITE[iFace]) {
                for (int i = 0; i < 6; ++i) {
                    sides[i] = this.reconfigControl.getSideConfig()[BlockHelper.INVERT_AROUND_Y[i]];
                }
            }
            this.reconfigControl.setSideConfig(sides);
        }
        this.updateSidedHandlers();
    }

    protected void chargeEnergy() {
        if (!this.chargeSlot.isEmpty()) {
            this.chargeSlot.getItemStack().getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace()), false), false));
        }
    }

    protected void transferInput() {
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        int newTracker = this.inputTracker;
        boolean updateTracker = false;
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isInput()) continue;
            for (ItemStorageCoFH itemStorageCoFH : this.inputSlots()) {
                if (itemStorageCoFH.getSpace() <= 0) continue;
                InventoryHelper.extractFromAdjacent((TileEntity)this, (ItemStorageCoFH)itemStorageCoFH, (int)Math.min(this.getInputItemAmount(), itemStorageCoFH.getSpace()), (Direction)side);
            }
            for (FluidStorageCoFH fluidStorageCoFH : this.inputTanks()) {
                if (fluidStorageCoFH.getSpace() <= 0) continue;
                FluidHelper.extractFromAdjacent((TileEntity)this, (FluidStorageCoFH)fluidStorageCoFH, (int)Math.min(this.getInputFluidAmount(), fluidStorageCoFH.getSpace()), (Direction)side);
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.inputTracker = newTracker;
    }

    protected void transferOutput() {
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        int newTracker = this.outputTracker;
        boolean updateTracker = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isOutput()) continue;
            for (ItemStorageCoFH itemStorageCoFH : this.outputSlots()) {
                InventoryHelper.insertIntoAdjacent((TileEntity)this, (ItemStorageCoFH)itemStorageCoFH, (int)this.getOutputItemAmount(), (Direction)side);
            }
            for (FluidStorageCoFH fluidStorageCoFH : this.outputTanks()) {
                FluidHelper.insertIntoAdjacent((TileEntity)this, (FluidStorageCoFH)fluidStorageCoFH, (int)this.getOutputFluidAmount(), (Direction)side);
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.outputTracker = newTracker;
    }

    protected int getInputItemAmount() {
        return 64;
    }

    protected int getOutputItemAmount() {
        return 64;
    }

    protected int getInputFluidAmount() {
        return 1000;
    }

    protected int getOutputFluidAmount() {
        return 1000;
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        super.getControlPacket(buffer);
        this.reconfigControl.writeToBuffer(buffer);
        this.transferControl.writeToBuffer(buffer);
        return buffer;
    }

    @Override
    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        this.reconfigControl.readFromBuffer(buffer);
        this.transferControl.readFromBuffer(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void handleStatePacket(PacketBuffer buffer) {
        super.handleStatePacket(buffer);
        ModelDataManager.requestModelDataRefresh((TileEntity)this);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.reconfigControl.setFacing(Direction.func_82600_a((int)nbt.func_74771_c("Facing")));
        this.reconfigControl.read(nbt);
        this.transferControl.read(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.updateSidedHandlers();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Facing", (byte)this.reconfigControl.getFacing().func_176745_a());
        this.reconfigControl.write(nbt);
        this.transferControl.write(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        return nbt;
    }

    public ReconfigControlModule reconfigControl() {
        return this.reconfigControl;
    }

    public TransferControlModule transferControl() {
        return this.transferControl;
    }

    @Override
    public void onControlUpdate() {
        this.updateSidedHandlers();
        super.onControlUpdate();
    }

    protected void updateSidedHandlers() {
        IItemHandler handler;
        int i;
        for (i = 0; i < 6; ++i) {
            this.sidedItemCaps[i].invalidate();
            switch (this.reconfigControl.getSideConfig(i)) {
                case SIDE_NONE: {
                    handler = EmptyHandler.INSTANCE;
                    break;
                }
                case SIDE_INPUT: {
                    handler = this.inventory.getHandler(StorageGroup.INPUT);
                    break;
                }
                case SIDE_OUTPUT: {
                    handler = this.inventory.getHandler(StorageGroup.OUTPUT);
                    break;
                }
                default: {
                    handler = this.inventory.getHandler(StorageGroup.ACCESSIBLE);
                }
            }
            this.sidedItemCaps[i] = LazyOptional.of(() -> handler).cast();
        }
        for (i = 0; i < 6; ++i) {
            this.sidedFluidCaps[i].invalidate();
            switch (this.reconfigControl.getSideConfig(i)) {
                case SIDE_NONE: {
                    handler = EmptyFluidHandler.INSTANCE;
                    break;
                }
                case SIDE_INPUT: {
                    handler = this.tankInv.getHandler(StorageGroup.INPUT);
                    break;
                }
                case SIDE_OUTPUT: {
                    handler = this.tankInv.getHandler(StorageGroup.OUTPUT);
                    break;
                }
                default: {
                    handler = this.tankInv.getHandler(StorageGroup.ACCESSIBLE);
                }
            }
            this.sidedFluidCaps[i] = LazyOptional.of(() -> ReconfigurableTile4Way.lambda$updateSidedHandlers$2((IFluidHandler)handler)).cast();
        }
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getItemHandlerCapability(side);
        }
        return this.sidedItemCaps[side.ordinal()].cast();
    }

    @Override
    protected <T> LazyOptional<T> getFluidHandlerCapability(@Nullable Direction side) {
        if (side == null) {
            return super.getFluidHandlerCapability(side);
        }
        return this.sidedFluidCaps[side.ordinal()].cast();
    }

    @Override
    public void readConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.reconfigControl.read(tag);
        this.transferControl.read(tag);
        super.readConveyableData(player, tag);
    }

    @Override
    public void writeConveyableData(PlayerEntity player, CompoundNBT tag) {
        this.reconfigControl.write(tag);
        this.transferControl.write(tag);
        super.writeConveyableData(player, tag);
    }

    private static /* synthetic */ IFluidHandler lambda$updateSidedHandlers$2(IFluidHandler handler) {
        return handler;
    }
}

