/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.device;

import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.inventory.ItemStorageInfinite;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.tileentity.ThermalTileBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class DeviceRockGenTile
extends ThermalTileBase {
    protected static ItemStack COBBLESTONE = new ItemStack((IItemProvider)Blocks.field_150347_e);
    protected static ItemStack BASALT = new ItemStack((IItemProvider)Blocks.field_150343_Z);
    protected byte adjLavaSource;
    protected byte adjWaterSource;
    protected byte adjBlueIce;
    protected byte adjSoulSand;
    protected boolean valid;
    protected ItemStorageCoFH slot = new ItemStorageInfinite(e -> false);

    public DeviceRockGenTile() {
        super(TCoreReferences.DEVICE_ROCK_GEN_TILE);
        this.inventory.addSlot(this.slot, StorageGroup.OUTPUT);
    }

    protected void updateValidity() {
        BlockPos[] cardinals;
        if (this.field_145850_b == null || !this.field_145850_b.isAreaLoaded(this.field_174879_c, 1)) {
            return;
        }
        this.adjLavaSource = 0;
        this.adjWaterSource = 0;
        this.adjBlueIce = 0;
        this.adjSoulSand = 0;
        this.valid = false;
        for (BlockPos adj : cardinals = new BlockPos[]{this.field_174879_c.func_177978_c(), this.field_174879_c.func_177968_d(), this.field_174879_c.func_177976_e(), this.field_174879_c.func_177974_f()}) {
            BlockState blockState = this.field_145850_b.func_180495_p(adj);
            FluidState fluidState = this.field_145850_b.func_204610_c(adj);
            if (fluidState.func_206886_c().equals(Fluids.field_204547_b)) {
                this.adjLavaSource = (byte)(this.adjLavaSource + 1);
            }
            if (fluidState.func_206886_c().equals(Fluids.field_204546_a)) {
                this.adjWaterSource = (byte)(this.adjWaterSource + 1);
            }
            if (!blockState.func_177230_c().equals(Blocks.field_205164_gk)) continue;
            this.adjBlueIce = (byte)(this.adjBlueIce + 1);
        }
        if (this.adjLavaSource > 0 && this.adjWaterSource > 0) {
            this.slot.setItemStack(ItemHelper.cloneStack((ItemStack)COBBLESTONE, (int)Math.min(this.adjLavaSource, this.adjWaterSource)));
            this.valid = true;
        } else {
            this.slot.clear();
        }
    }

    protected void updateActiveState() {
        this.updateValidity();
        boolean curActive = this.isActive;
        this.isActive = this.redstoneControl().getState() && this.valid;
        this.updateActiveState(curActive);
    }

    @Override
    public void neighborChanged(Block blockIn, BlockPos fromPos) {
        super.neighborChanged(blockIn, fromPos);
        this.updateActiveState();
    }

    public boolean onActivatedDelegate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        return player.field_71071_by.func_70441_a(ItemHelper.cloneStack((ItemStack)this.slot.getItemStack()));
    }

    @Override
    public void onPlacedBy(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.onPlacedBy(worldIn, pos, state, placer, stack);
        this.updateActiveState();
    }

    public boolean canOpenGui() {
        return false;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.inventory.hasSlots()) {
            return LazyOptional.of(() -> this.isActive ? this.inventory.getHandler(StorageGroup.OUTPUT) : EmptyHandler.INSTANCE).cast();
        }
        return super.getCapability(cap, side);
    }
}

