/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.tileentity.workbench;

import cofh.core.energy.EnergyStorageCoFH;
import cofh.core.fluid.FluidStorageCoFH;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.inventory.container.workbench.TinkerBenchContainer;
import cofh.thermal.core.tileentity.ThermalTileBase;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TinkerBenchTile
extends ThermalTileBase
implements ITickableTileEntity {
    protected ItemStorageCoFH tinkerSlot = new ItemStorageCoFH(1, item -> AugmentableHelper.isAugmentableItem((ItemStack)item) || EnergyHelper.hasEnergyHandlerCap((ItemStack)item) || FluidHelper.hasFluidHandlerCap((ItemStack)item));
    protected ItemStorageCoFH chargeSlot = new ItemStorageCoFH(1, EnergyHelper::hasEnergyHandlerCap);
    protected ItemStorageCoFH tankSlot = new ItemStorageCoFH(1, FluidHelper::hasFluidHandlerCap);
    protected FluidStorageCoFH tank = new FluidStorageCoFH(8000);
    protected static final int BASE_ENERGY = 200000;
    protected static final int BASE_TRANSFER = 1000;
    protected static final byte REPLENISH = 0;
    protected static final byte AUGMENT = 1;
    protected byte mode;
    protected boolean pause;

    public TinkerBenchTile() {
        super(TCoreReferences.TINKER_BENCH_TILE);
        this.energyStorage = new EnergyStorageCoFH(200000, 1000);
        this.inventory.addSlot(this.tinkerSlot, StorageGroup.INTERNAL);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.inventory.addSlot(this.tankSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.tank, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalConfig.storageAugments);
        this.initHandlers();
    }

    public void func_73660_a() {
        if (this.redstoneControl.getState()) {
            this.chargeEnergy();
            this.fillFluid();
        }
    }

    public void setPause(boolean pause) {
        this.pause = pause;
    }

    public boolean allowAugmentation() {
        return this.mode == 1;
    }

    public void toggleTinkerSlotMode() {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 2);
    }

    protected void chargeEnergy() {
        int maxTransfer;
        if (!this.chargeSlot.isEmpty()) {
            maxTransfer = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getSpace());
            this.chargeSlot.getItemStack().getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> this.energyStorage.receiveEnergy(c.extractEnergy(maxTransfer, false), false));
        }
        if (!this.tinkerSlot.isEmpty() && this.mode == 0 && !this.pause) {
            maxTransfer = Math.min(this.energyStorage.getMaxExtract(), this.energyStorage.getEnergyStored());
            this.tinkerSlot.getItemStack().getCapability(CapabilityEnergy.ENERGY, null).ifPresent(c -> this.energyStorage.extractEnergy(c.receiveEnergy(maxTransfer, false), false));
        }
    }

    protected void fillFluid() {
        if (!this.tankSlot.isEmpty()) {
            this.tankSlot.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                c.drain(this.tank.fill(new FluidStack(c.getFluidInTank(0), 1000), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.tankSlot.setItemStack(c.getContainer());
            });
        }
        if (!this.tinkerSlot.isEmpty() && this.mode == 0 && !this.pause) {
            this.tinkerSlot.getItemStack().getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> {
                this.tank.drain(c.fill(new FluidStack(this.tank.getFluidStack(), 1000), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                this.tinkerSlot.setItemStack(c.getContainer());
            });
        }
    }

    public boolean canOpenGui() {
        return this.numPlayersUsing <= 0;
    }

    @Override
    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeByte((int)this.mode);
        return buffer;
    }

    @Override
    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.mode = buffer.readByte();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.mode = nbt.func_74771_c("Mode");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Mode", this.mode);
        return nbt;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new TinkerBenchContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }
}

