/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.world.biome;

import cofh.thermal.core.common.ThermalFlags;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.world.gen.feature.ThermalFeatures;
import net.minecraft.entity.EntityClassification;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ThermalBiomeFeatures {
    private ThermalBiomeFeatures() {
    }

    public static void addOreGeneration(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder generationSettingsBuilder = event.getGeneration();
        Biome.Category category = event.getCategory();
        if (ThermalBiomeFeatures.isOverworldBiome(category)) {
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_APATITE).getAsBoolean()) {
                ThermalBiomeFeatures.withApatiteOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_CINNABAR).getAsBoolean()) {
                ThermalBiomeFeatures.withCinnabarOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_NITER).getAsBoolean()) {
                ThermalBiomeFeatures.withNiterOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SULFUR).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_SULFUR).getAsBoolean()) {
                ThermalBiomeFeatures.withSulfurOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_COPPER).getAsBoolean()) {
                ThermalBiomeFeatures.withCopperOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_TIN).getAsBoolean()) {
                ThermalBiomeFeatures.withTinOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_LEAD).getAsBoolean()) {
                ThermalBiomeFeatures.withLeadOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_SILVER).getAsBoolean()) {
                ThermalBiomeFeatures.withSilverOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
            if (ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL).getAsBoolean() && ThermalFlags.getFlag(ThermalFlags.FLAG_GEN_NICKEL).getAsBoolean()) {
                ThermalBiomeFeatures.withNickelOre((BiomeGenerationSettings.Builder)generationSettingsBuilder);
            }
        }
    }

    public static void addHostileSpawns(BiomeLoadingEvent event) {
        MobSpawnInfoBuilder spawnInfoBuilder = event.getSpawns();
        if (spawnInfoBuilder.getSpawner(EntityClassification.MONSTER).isEmpty()) {
            return;
        }
        Biome.Category category = event.getCategory();
        Biome.Climate climate = event.getClimate();
        if (ThermalBiomeFeatures.isOverworldBiome(category)) {
            if (category == Biome.Category.EXTREME_HILLS || category == Biome.Category.MESA) {
                ThermalBiomeFeatures.withBasalz(spawnInfoBuilder);
            }
            if (category == Biome.Category.DESERT || category == Biome.Category.MESA || category == Biome.Category.SAVANNA) {
                ThermalBiomeFeatures.withBlitz(spawnInfoBuilder);
            }
            if (climate.field_242460_b == Biome.RainType.SNOW & climate.field_242461_c <= 0.3f) {
                ThermalBiomeFeatures.withBlizz(spawnInfoBuilder);
            }
        }
    }

    public static void withApatiteOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_APATITE);
    }

    public static void withCinnabarOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_CINNABAR);
    }

    public static void withNiterOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_NITER);
    }

    public static void withSulfurOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_SULFUR);
    }

    public static void withCopperOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_COPPER);
    }

    public static void withTinOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_TIN);
    }

    public static void withLeadOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_LEAD);
    }

    public static void withSilverOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_SILVER);
    }

    public static void withNickelOre(BiomeGenerationSettings.Builder builder) {
        builder.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ThermalFeatures.ORE_NICKEL);
    }

    public static void withBasalz(MobSpawnInfoBuilder builder) {
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(TCoreReferences.BASALZ_ENTITY, 10, 1, 3));
    }

    public static void withBlitz(MobSpawnInfoBuilder builder) {
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(TCoreReferences.BLITZ_ENTITY, 10, 1, 3));
    }

    public static void withBlizz(MobSpawnInfoBuilder builder) {
        builder.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(TCoreReferences.BLIZZ_ENTITY, 10, 1, 3));
    }

    public static boolean isOverworldBiome(Biome.Category category) {
        return category != Biome.Category.NONE && category != Biome.Category.THEEND && category != Biome.Category.NETHER;
    }
}

