/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.plugins.jei.machine;

import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.plugins.jei.ThermalRecipeCategory;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineFurnaceScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.util.recipes.machine.FurnaceRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FurnaceRecipeCategory
extends ThermalRecipeCategory<FurnaceRecipe> {
    public FurnaceRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineFurnaceScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_FURNACE_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends FurnaceRecipe> getRecipeClass() {
        return FurnaceRecipe.class;
    }

    public void setIngredients(FurnaceRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
    }

    public void setRecipe(IRecipeLayout layout, FurnaceRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 42, 14);
        guiItemStacks.init(1, false, 105, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
        this.addDefaultItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 1);
    }

    public void draw(FurnaceRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 69, 23);
        this.speedBackground.draw(matrixStack, 43, 33);
        this.progress.draw(matrixStack, 69, 23);
        this.speed.draw(matrixStack, 43, 33);
    }
}

