/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.plugins.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.plugins.jei.TCoreJeiPlugin;
import cofh.thermal.core.plugins.jei.ThermalRecipeCategory;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineRefineryScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.util.recipes.machine.RefineryRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeCategory
extends ThermalRecipeCategory<RefineryRecipe> {
    protected IDrawableStatic tankInput;
    protected IDrawableStatic tankOutputA;
    protected IDrawableStatic tankOutputB;
    protected IDrawableStatic inputOverlay;
    protected IDrawableStatic outputOverlayA;
    protected IDrawableStatic outputOverlayB;

    public RefineryRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineRefineryScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_REFINERY_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(4);
        this.tankInput = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(2);
        this.tankOutputA = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOutputB = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.inputOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(2);
        this.outputOverlayA = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.outputOverlayB = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(4), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends RefineryRecipe> getRecipeClass() {
        return RefineryRecipe.class;
    }

    public void setIngredients(RefineryRecipe recipe, IIngredients ingredients) {
        ingredients.setInputs(VanillaTypes.FLUID, recipe.getInputFluids());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.getOutputFluids());
    }

    public void setRecipe(IRecipeLayout layout, RefineryRecipe recipe, IIngredients ingredients) {
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        List outputFluids = ingredients.getOutputs(VanillaTypes.FLUID);
        List outputItems = ingredients.getOutputs(VanillaTypes.ITEM);
        for (int i = 0; i < outputItems.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputItems.get(i)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiItemStacks.init(0, false, 96, 23);
        guiFluidStacks.init(0, true, 29, 6, 16, 32, TCoreJeiPlugin.tankSize((int)4000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.inputOverlay));
        guiFluidStacks.init(1, false, 126, 12, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.outputOverlayA));
        guiFluidStacks.init(2, false, 144, 12, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.outputOverlayB));
        if (!outputItems.isEmpty()) {
            guiItemStacks.set(0, (List)outputItems.get(0));
        }
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        for (int i = 0; i < outputFluids.size(); ++i) {
            guiFluidStacks.set(i + 1, (List)outputFluids.get(i));
        }
        this.addDefaultItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 0);
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(RefineryRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 57, 22);
        this.tankInput.draw(matrixStack, 28, 5);
        this.tankOutputA.draw(matrixStack, 125, 11);
        this.tankOutputB.draw(matrixStack, 143, 11);
        this.speedBackground.draw(matrixStack, 29, 40);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((MatrixStack)matrixStack, (int)57, (int)22, (FluidStack)((FluidStack)recipe.getInputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 57, 22);
            this.progressFluid.draw(matrixStack, 57, 22);
        } else {
            this.progress.draw(matrixStack, 57, 22);
        }
        this.speed.draw(matrixStack, 29, 40);
    }
}

