/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.plugins.jei.machine;

import cofh.core.util.helpers.StringHelper;
import cofh.thermal.core.plugins.jei.Drawables;
import cofh.thermal.core.plugins.jei.ThermalRecipeCategory;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineSawmillScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.util.recipes.machine.SawmillRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SawmillRecipeCategory
extends ThermalRecipeCategory<SawmillRecipe> {
    public SawmillRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineSawmillScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_SAWMILL_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(7);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(7), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends SawmillRecipe> getRecipeClass() {
        return SawmillRecipe.class;
    }

    public void setIngredients(SawmillRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
    }

    public void setRecipe(IRecipeLayout layout, SawmillRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputs.get(i)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 33, 14);
        guiItemStacks.init(1, false, 96, 14);
        guiItemStacks.init(2, false, 114, 14);
        guiItemStacks.init(3, false, 96, 32);
        guiItemStacks.init(4, false, 114, 32);
        guiItemStacks.set(0, (List)inputs.get(0));
        for (int i = 0; i < outputs.size(); ++i) {
            guiItemStacks.set(i + 1, (List)outputs.get(i));
        }
        this.addDefaultItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 1);
    }

    public void draw(SawmillRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 62, 23);
        this.speedBackground.draw(matrixStack, 34, 33);
        this.progress.draw(matrixStack, 62, 23);
        this.speed.draw(matrixStack, 34, 33);
    }
}

