/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.device;

import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.constants.Constants;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.tileentity.ReconfigurableTile4Way;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.device.DeviceItemBufferContainer;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;

public class DeviceItemBufferTile
extends ReconfigurableTile4Way
implements ITickableTileEntity {
    public static int XFER_MAX = 64;
    public int amountInput = 4;
    public int amountOutput = 4;

    public DeviceItemBufferTile() {
        super(TExpReferences.DEVICE_ITEM_BUFFER_TILE);
        this.inventory.addSlots(StorageGroup.ACCESSIBLE, 9);
        this.initHandlers();
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.timeCheckHalf()) {
                this.transferOutput();
                this.transferInput();
            }
            if (!this.redstoneControl.getState()) {
                this.isActive = false;
            }
        } else if (this.redstoneControl.getState()) {
            this.isActive = true;
        }
        this.updateActiveState(curActive);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DeviceItemBufferContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected void transferInput() {
        if (!this.transferControl.getTransferIn()) {
            return;
        }
        int newTracker = this.inputTracker;
        boolean updateTracker = false;
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            ItemStorageCoFH slot;
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isInput()) continue;
            Iterator iterator = this.inputSlots().iterator();
            while (iterator.hasNext() && ((slot = (ItemStorageCoFH)iterator.next()).getSpace() <= 0 || !InventoryHelper.extractFromAdjacent((TileEntity)this, (ItemStorageCoFH)slot, (int)Math.min(this.getInputItemAmount(), slot.getSpace()), (Direction)side))) {
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.inputTracker = newTracker;
    }

    protected void transferOutput() {
        if (!this.transferControl.getTransferOut()) {
            return;
        }
        int newTracker = this.outputTracker;
        boolean updateTracker = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            Direction side = Constants.DIRECTIONS[i % 6];
            if (!this.reconfigControl.getSideConfig(side).isOutput()) continue;
            int j = this.outputSlots().size();
            while (j-- > 0 && !InventoryHelper.insertIntoAdjacent((TileEntity)this, (ItemStorageCoFH)((ItemStorageCoFH)this.outputSlots().get(j)), (int)this.getOutputItemAmount(), (Direction)side)) {
            }
            if (updateTracker) continue;
            newTracker = side.ordinal();
            updateTracker = true;
        }
        this.outputTracker = newTracker;
    }

    protected int getInputItemAmount() {
        return this.amountInput;
    }

    protected int getOutputItemAmount() {
        return this.amountOutput;
    }

    public PacketBuffer getConfigPacket(PacketBuffer buffer) {
        super.getConfigPacket(buffer);
        buffer.writeByte(this.amountInput);
        buffer.writeByte(this.amountOutput);
        return buffer;
    }

    public PacketBuffer getGuiPacket(PacketBuffer buffer) {
        super.getGuiPacket(buffer);
        buffer.writeByte(this.amountInput);
        buffer.writeByte(this.amountOutput);
        return buffer;
    }

    public void handleConfigPacket(PacketBuffer buffer) {
        super.handleConfigPacket(buffer);
        this.amountInput = MathHelper.clamp((int)buffer.readByte(), (int)0, (int)XFER_MAX);
        this.amountOutput = MathHelper.clamp((int)buffer.readByte(), (int)0, (int)XFER_MAX);
    }

    public void handleGuiPacket(PacketBuffer buffer) {
        super.handleGuiPacket(buffer);
        this.amountInput = buffer.readByte();
        this.amountOutput = buffer.readByte();
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.amountInput = nbt.func_74762_e("AmountIn");
        this.amountOutput = nbt.func_74762_e("AmountOut");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("AmountIn", this.amountInput);
        nbt.func_74768_a("AmountOut", this.amountOutput);
        return nbt;
    }
}

