/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.core.inventory.IItemStackAccess;
import cofh.core.inventory.ItemStorageCoFH;
import cofh.core.util.StorageGroup;
import cofh.core.util.helpers.MathHelper;
import cofh.thermal.core.common.ThermalConfig;
import cofh.thermal.core.tileentity.MachineTileProcess;
import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.machine.MachinePulverizerContainer;
import cofh.thermal.expansion.util.managers.machine.PulverizerRecipeManager;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;

public class MachinePulverizerTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(arg_0 -> ((PulverizerRecipeManager)PulverizerRecipeManager.instance()).validRecipe(arg_0));
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(arg_0 -> ((PulverizerRecipeManager)PulverizerRecipeManager.instance()).validCatalyst(arg_0));

    public MachinePulverizerTile() {
        super(TExpReferences.MACHINE_PULVERIZER_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = PulverizerRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = PulverizerRecipeManager.instance().getCatalyst((IItemStackAccess)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        int n = decrement = this.itemInputCounts.size() > 1 ? (Integer)this.itemInputCounts.get(1) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().func_77984_f()) {
                if (this.catalystSlot.getItemStack().func_96631_a(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachinePulverizerContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }
}

