/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.dynamo;

import cofh.thermal.core.util.managers.SingleItemFuelManager;
import cofh.thermal.core.util.recipes.ThermalFuel;
import cofh.thermal.core.util.recipes.internal.IDynamoFuel;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import cofh.thermal.expansion.util.recipes.dynamo.StirlingFuel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class StirlingFuelManager
extends SingleItemFuelManager {
    private static final StirlingFuelManager INSTANCE = new StirlingFuelManager();
    protected static int DEFAULT_ENERGY = 16000;
    protected List<StirlingFuel> convertedFuels = new ArrayList<StirlingFuel>();

    public static StirlingFuelManager instance() {
        return INSTANCE;
    }

    private StirlingFuelManager() {
        super(DEFAULT_ENERGY);
    }

    public boolean validFuel(ItemStack input) {
        if (input.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        return this.getEnergy(input) > 0;
    }

    protected void clear() {
        this.fuelMap.clear();
        this.convertedFuels.clear();
    }

    public int getEnergy(ItemStack stack) {
        IDynamoFuel fuel = this.getFuel(stack);
        return fuel != null ? fuel.getEnergy() : this.getEnergyFurnaceFuel(stack);
    }

    public int getEnergyFurnaceFuel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            return 0;
        }
        int energy = ForgeHooks.getBurnTime((ItemStack)stack) * 10;
        return energy >= 1000 ? energy : 0;
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.FUEL_STIRLING);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addFuel((ThermalFuel)entry.getValue());
        }
        this.createConvertedRecipes(recipeManager);
    }

    public List<StirlingFuel> getConvertedFuels() {
        return this.convertedFuels;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        for (Item item : ForgeRegistries.ITEMS) {
            ItemStack query = new ItemStack((IItemProvider)item);
            if (this.getFuel(query) != null || !this.validFuel(query)) continue;
            this.convertedFuels.add(this.convert(query, this.getEnergy(query)));
        }
    }

    protected StirlingFuel convert(ItemStack item, int energy) {
        return new StirlingFuel(new ResourceLocation("thermal", "stirling_" + item.func_77973_b().getRegistryName().func_110623_a()), energy, Collections.singletonList(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{item})), Collections.emptyList());
    }
}

