/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.core.fluid.IFluidStackAccess;
import cofh.core.fluid.PotionFluid;
import cofh.core.inventory.IItemStackAccess;
import cofh.core.util.ComparableItemStack;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.managers.AbstractManager;
import cofh.thermal.core.util.managers.IRecipeManager;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.SimpleMachineRecipe;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import cofh.thermal.expansion.util.recipes.machine.BrewerRecipe;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BrewerRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final BrewerRecipeManager INSTANCE = new BrewerRecipeManager();
    protected static final int DEFAULT_ENERGY = 4000;
    protected static boolean defaultPotionRecipes = true;
    protected int defaultPotion = 1000;
    protected Map<List<Integer>, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected Set<Fluid> validFluids = new ObjectOpenHashSet();
    protected Set<ComparableItemStack> validItems = new ObjectOpenHashSet();
    protected int maxOutputItems = 0;
    protected int maxOutputFluids = 1;
    protected List<BrewerRecipe> convertedRecipes = new ArrayList<BrewerRecipe>();

    public static BrewerRecipeManager instance() {
        return INSTANCE;
    }

    private BrewerRecipeManager() {
        super(4000);
    }

    public void addRecipe(ThermalRecipe recipe) {
        for (ItemStack recipeInput : ((Ingredient)recipe.getInputItems().get(0)).func_193365_a()) {
            this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Collections.singletonList(recipeInput), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
        }
    }

    public boolean validItem(ItemStack item) {
        return this.validItems.contains(BrewerRecipeManager.convert((ItemStack)item));
    }

    public boolean validFluid(FluidStack fluid) {
        return this.validFluids.contains(fluid.getFluid());
    }

    protected void clear() {
        this.recipeMap.clear();
        this.validFluids.clear();
        this.validItems.clear();
        this.convertedRecipes.clear();
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputSlots.isEmpty() || inputSlots.get(0).isEmpty() || inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        ItemStack inputItem = inputSlots.get(0).getItemStack();
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(Arrays.asList(BrewerRecipeManager.convert((ItemStack)inputItem).hashCode(), FluidHelper.fluidHashcode((FluidStack)inputFluid)));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || inputFluids.isEmpty() || outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack inputItem = inputItems.get(0);
        if (inputItem.func_190926_b()) {
            return null;
        }
        FluidStack inputFluid = inputFluids.get(0);
        if (inputFluid.isEmpty()) {
            return null;
        }
        for (FluidStack stack : outputFluids) {
            if (!stack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(Arrays.asList(BrewerRecipeManager.convert((ItemStack)inputItem).hashCode(), FluidHelper.fluidHashcode((FluidStack)inputFluid)), (IMachineRecipe)recipe);
        this.validItems.add(BrewerRecipeManager.convert((ItemStack)inputItem));
        this.validFluids.add(inputFluid.getFluid());
        return recipe;
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        if (defaultPotionRecipes) {
            ThermalCore.LOG.debug("Adding default Brewing Stand recipes to the Alchemical Imbuer...");
            this.createConvertedRecipes();
            for (ThermalRecipe thermalRecipe : this.getConvertedRecipes()) {
                this.addRecipe(thermalRecipe);
            }
        }
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_BREWER);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)entry.getValue());
        }
    }

    public List<BrewerRecipe> getConvertedRecipes() {
        return this.convertedRecipes;
    }

    protected void createConvertedRecipes() {
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151060_bw, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151073_bk, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_179556_br, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151065_br, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151070_bp, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151102_aT, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151064_bs, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151114_aO, Potions.field_185232_d);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151137_ax, Potions.field_185231_c);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151075_bm, Potions.field_185233_e);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151150_bK, Potions.field_185234_f);
        this.createConvertedRecipe(Potions.field_185234_f, Items.field_151137_ax, Potions.field_185235_g);
        this.createConvertedRecipe(Potions.field_185234_f, Items.field_151071_bq, Potions.field_185236_h);
        this.createConvertedRecipe(Potions.field_185235_g, Items.field_151071_bq, Potions.field_185237_i);
        this.createConvertedRecipe(Potions.field_185236_h, Items.field_151137_ax, Potions.field_185237_i);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151064_bs, Potions.field_185241_m);
        this.createConvertedRecipe(Potions.field_185241_m, Items.field_151137_ax, Potions.field_185242_n);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_179556_br, Potions.field_185238_j);
        this.createConvertedRecipe(Potions.field_185238_j, Items.field_151137_ax, Potions.field_185239_k);
        this.createConvertedRecipe(Potions.field_185238_j, Items.field_151114_aO, Potions.field_185240_l);
        this.createConvertedRecipe(Potions.field_185238_j, Items.field_151071_bq, Potions.field_185246_r);
        this.createConvertedRecipe(Potions.field_185239_k, Items.field_151071_bq, Potions.field_185247_s);
        this.createConvertedRecipe(Potions.field_185246_r, Items.field_151137_ax, Potions.field_185247_s);
        this.createConvertedRecipe(Potions.field_185246_r, Items.field_151114_aO, Potions.field_203185_t);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_203179_ao, Potions.field_203186_u);
        this.createConvertedRecipe(Potions.field_203186_u, Items.field_151137_ax, Potions.field_203187_v);
        this.createConvertedRecipe(Potions.field_203186_u, Items.field_151114_aO, Potions.field_203188_w);
        this.createConvertedRecipe(Potions.field_185243_o, Items.field_151071_bq, Potions.field_185246_r);
        this.createConvertedRecipe(Potions.field_185244_p, Items.field_151071_bq, Potions.field_185247_s);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151102_aT, Potions.field_185243_o);
        this.createConvertedRecipe(Potions.field_185243_o, Items.field_151137_ax, Potions.field_185244_p);
        this.createConvertedRecipe(Potions.field_185243_o, Items.field_151114_aO, Potions.field_185245_q);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_196089_aZ, Potions.field_185248_t);
        this.createConvertedRecipe(Potions.field_185248_t, Items.field_151137_ax, Potions.field_185249_u);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151060_bw, Potions.field_185250_v);
        this.createConvertedRecipe(Potions.field_185250_v, Items.field_151114_aO, Potions.field_185251_w);
        this.createConvertedRecipe(Potions.field_185250_v, Items.field_151071_bq, Potions.field_185252_x);
        this.createConvertedRecipe(Potions.field_185251_w, Items.field_151071_bq, Potions.field_185253_y);
        this.createConvertedRecipe(Potions.field_185252_x, Items.field_151114_aO, Potions.field_185253_y);
        this.createConvertedRecipe(Potions.field_185254_z, Items.field_151071_bq, Potions.field_185252_x);
        this.createConvertedRecipe(Potions.field_185218_A, Items.field_151071_bq, Potions.field_185252_x);
        this.createConvertedRecipe(Potions.field_185219_B, Items.field_151071_bq, Potions.field_185253_y);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151070_bp, Potions.field_185254_z);
        this.createConvertedRecipe(Potions.field_185254_z, Items.field_151137_ax, Potions.field_185218_A);
        this.createConvertedRecipe(Potions.field_185254_z, Items.field_151114_aO, Potions.field_185219_B);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151073_bk, Potions.field_185220_C);
        this.createConvertedRecipe(Potions.field_185220_C, Items.field_151137_ax, Potions.field_185221_D);
        this.createConvertedRecipe(Potions.field_185220_C, Items.field_151114_aO, Potions.field_185222_E);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_151065_br, Potions.field_185223_F);
        this.createConvertedRecipe(Potions.field_185223_F, Items.field_151137_ax, Potions.field_185224_G);
        this.createConvertedRecipe(Potions.field_185223_F, Items.field_151114_aO, Potions.field_185225_H);
        this.createConvertedRecipe(Potions.field_185230_b, Items.field_151071_bq, Potions.field_185226_I);
        this.createConvertedRecipe(Potions.field_185226_I, Items.field_151137_ax, Potions.field_185227_J);
        this.createConvertedRecipe(Potions.field_185233_e, Items.field_204840_eX, Potions.field_204841_O);
        this.createConvertedRecipe(Potions.field_204841_O, Items.field_151137_ax, Potions.field_204842_P);
    }

    protected boolean createConvertedRecipe(Potion inputPotion, Item reagent, Potion outputPotion) {
        if (inputPotion == null || reagent == null || outputPotion == null) {
            return false;
        }
        this.convertedRecipes.add(this.convert(inputPotion, reagent, outputPotion));
        return true;
    }

    protected BrewerRecipe convert(Potion inputPotion, Item reagent, Potion outputPotion) {
        return this.convert(inputPotion, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{reagent}), outputPotion);
    }

    protected BrewerRecipe convert(Potion inputPotion, Ingredient reagent, Potion outputPotion) {
        return new BrewerRecipe(new ResourceLocation("thermal", "brewer_" + inputPotion.hashCode()), this.defaultEnergy, 0.0f, -1, Collections.singletonList(reagent), Collections.singletonList(PotionFluid.getPotionAsFluid((int)this.defaultPotion, (Potion)inputPotion)), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(PotionFluid.getPotionAsFluid((int)this.defaultPotion, (Potion)outputPotion)));
    }
}

