/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.util.managers.SingleItemRecipeManager;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import cofh.thermal.expansion.util.recipes.machine.FurnaceRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.ResourceLocation;

public class FurnaceRecipeManager
extends SingleItemRecipeManager {
    private static final FurnaceRecipeManager INSTANCE = new FurnaceRecipeManager();
    protected static final int DEFAULT_ENERGY = 2000;
    protected static boolean defaultFurnaceRecipes = true;
    protected static boolean defaultFoodRecipes = true;
    protected List<FurnaceRecipe> convertedRecipes = new ArrayList<FurnaceRecipe>();

    public static FurnaceRecipeManager instance() {
        return INSTANCE;
    }

    private FurnaceRecipeManager() {
        super(2000, 1, 0);
    }

    protected void clear() {
        this.recipeMap.clear();
        this.convertedRecipes.clear();
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        if (defaultFurnaceRecipes) {
            ThermalCore.LOG.debug("Adding default Furnace recipes to the Redstone Furnace...");
            this.createConvertedRecipes(recipeManager);
            for (ThermalRecipe thermalRecipe : this.getConvertedRecipes()) {
                this.addRecipe(thermalRecipe);
            }
        }
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_FURNACE);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)entry.getValue());
        }
    }

    public List<FurnaceRecipe> getConvertedRecipes() {
        return this.convertedRecipes;
    }

    protected void createConvertedRecipes(RecipeManager recipeManager) {
        for (IRecipe recipe : recipeManager.func_215366_a(IRecipeType.field_222150_b).values()) {
            this.createConvertedRecipe((AbstractCookingRecipe)recipe);
        }
    }

    protected boolean createConvertedRecipe(AbstractCookingRecipe recipe) {
        if (recipe.func_192399_d() || recipe.func_77571_b().func_190926_b()) {
            return false;
        }
        this.convertedRecipes.add(this.convert(recipe));
        return true;
    }

    protected FurnaceRecipe convert(AbstractCookingRecipe recipe) {
        ItemStack recipeOutput = recipe.func_77571_b();
        float experience = recipe.func_222138_b();
        int energy = defaultFoodRecipes && recipeOutput.func_77973_b().func_219971_r() ? this.defaultEnergy / 2 : this.defaultEnergy;
        return new FurnaceRecipe(new ResourceLocation("thermal", "furnace_" + ((Ingredient)recipe.func_192400_c().get(0)).hashCode()), energy, experience, recipe);
    }
}

