/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.thermal.core.util.IMachineInventory;
import cofh.thermal.core.util.managers.SingleItemRecipeManager;
import cofh.thermal.core.util.recipes.ThermalCatalyst;
import cofh.thermal.core.util.recipes.internal.CatalyzedMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.IRecipeCatalyst;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import cofh.thermal.expansion.util.recipes.machine.InsolatorRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeManager
extends SingleItemRecipeManager.Catalyzed {
    private static final InsolatorRecipeManager INSTANCE = new InsolatorRecipeManager();
    protected static final int DEFAULT_ENERGY = 20000;
    protected int defaultWater = 500;

    public static InsolatorRecipeManager instance() {
        return INSTANCE;
    }

    private InsolatorRecipeManager() {
        super(20000, 4, 0);
    }

    public int getDefaultWater() {
        return this.defaultWater;
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputItems.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        ItemStack input = inputItems.get(0);
        if (input.func_190926_b()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        InternalInsolatorRecipe recipe = new InternalInsolatorRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(InsolatorRecipeManager.convert((ItemStack)input), recipe);
        return recipe;
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_INSOLATOR);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((InsolatorRecipe)((Object)entry.getValue()));
        }
        Map catalysts = recipeManager.func_215366_a(TExpRecipeTypes.CATALYST_INSOLATOR);
        for (Map.Entry entry : catalysts.entrySet()) {
            this.addCatalyst((ThermalCatalyst)entry.getValue());
        }
    }

    protected static class InternalInsolatorRecipe
    extends CatalyzedMachineRecipe {
        public InternalInsolatorRecipe(int energy, float experience, int minTicks, @Nullable List<ItemStack> inputItems, @Nullable List<FluidStack> inputFluids, @Nullable List<ItemStack> outputItems, @Nullable List<Float> chance, @Nullable List<FluidStack> outputFluids) {
            super(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        }

        public List<Integer> getInputFluidCounts(IMachineInventory inventory) {
            if (this.inputFluids.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> ret = new ArrayList<Integer>(this.inputFluids.size());
            for (FluidStack input : this.inputFluids) {
                ret.add(input.getAmount());
            }
            return ret;
        }

        public IRecipeCatalyst getCatalyst(ItemStack input) {
            return InsolatorRecipeManager.instance().getCatalyst(input);
        }
    }
}

