/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.managers.machine;

import cofh.core.fluid.FluidStackHolder;
import cofh.core.fluid.IFluidStackAccess;
import cofh.core.inventory.IItemStackAccess;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermal.core.util.IThermalInventory;
import cofh.thermal.core.util.managers.AbstractManager;
import cofh.thermal.core.util.managers.IRecipeManager;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.internal.IMachineRecipe;
import cofh.thermal.core.util.recipes.internal.SimpleMachineRecipe;
import cofh.thermal.expansion.init.TExpRecipeTypes;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipeManager
extends AbstractManager
implements IRecipeManager {
    private static final RefineryRecipeManager INSTANCE = new RefineryRecipeManager();
    protected static final int DEFAULT_ENERGY = 8000;
    protected Map<Integer, IMachineRecipe> recipeMap = new Object2ObjectOpenHashMap();
    protected int maxOutputItems = 1;
    protected int maxOutputFluids = 2;

    public static RefineryRecipeManager instance() {
        return INSTANCE;
    }

    private RefineryRecipeManager() {
        super(8000);
    }

    public void addRecipe(ThermalRecipe recipe) {
        this.addRecipe(recipe.getEnergy(), recipe.getExperience(), recipe.getMinTicks(), Collections.emptyList(), recipe.getInputFluids(), recipe.getOutputItems(), recipe.getOutputItemChances(), recipe.getOutputFluids());
    }

    public boolean validRecipe(FluidStack input) {
        return this.getRecipe(input) != null;
    }

    protected void clear() {
        this.recipeMap.clear();
    }

    protected IMachineRecipe getRecipe(FluidStack input) {
        return this.getRecipe(Collections.emptyList(), Collections.singletonList(new FluidStackHolder(input)));
    }

    protected IMachineRecipe getRecipe(List<? extends IItemStackAccess> inputSlots, List<? extends IFluidStackAccess> inputTanks) {
        if (inputTanks.isEmpty() || inputTanks.get(0).isEmpty()) {
            return null;
        }
        FluidStack inputFluid = inputTanks.get(0).getFluidStack();
        return this.recipeMap.get(FluidHelper.fluidHashcode((FluidStack)inputFluid));
    }

    protected IMachineRecipe addRecipe(int energy, float experience, int minTicks, List<ItemStack> inputItems, List<FluidStack> inputFluids, List<ItemStack> outputItems, List<Float> chance, List<FluidStack> outputFluids) {
        if (inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty() || outputItems.size() > this.maxOutputItems || outputFluids.size() > this.maxOutputFluids || energy <= 0) {
            return null;
        }
        FluidStack input = inputFluids.get(0);
        if (input.isEmpty()) {
            return null;
        }
        for (ItemStack itemStack : outputItems) {
            if (!itemStack.func_190926_b()) continue;
            return null;
        }
        for (FluidStack fluidStack : outputFluids) {
            if (!fluidStack.isEmpty()) continue;
            return null;
        }
        energy = (int)((float)energy * this.getDefaultScale());
        SimpleMachineRecipe recipe = new SimpleMachineRecipe(energy, experience, minTicks, inputItems, inputFluids, outputItems, chance, outputFluids);
        this.recipeMap.put(FluidHelper.fluidHashcode((FluidStack)input), (IMachineRecipe)recipe);
        return recipe;
    }

    public IMachineRecipe getRecipe(IThermalInventory inventory) {
        return this.getRecipe(inventory.inputSlots(), inventory.inputTanks());
    }

    public List<IMachineRecipe> getRecipeList() {
        return new ArrayList<IMachineRecipe>(this.recipeMap.values());
    }

    public void config() {
    }

    public void refresh(RecipeManager recipeManager) {
        this.clear();
        Map recipes = recipeManager.func_215366_a(TExpRecipeTypes.RECIPE_REFINERY);
        for (Map.Entry entry : recipes.entrySet()) {
            this.addRecipe((ThermalRecipe)entry.getValue());
        }
    }
}

