/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.util.recipes.machine;

import cofh.core.util.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.ThermalRecipe;
import cofh.thermal.core.util.recipes.ThermalRecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeSerializer<T extends ThermalRecipe>
extends ThermalRecipeSerializer<T> {
    protected final int defaultWater;

    public InsolatorRecipeSerializer(ThermalRecipeSerializer.IFactory<T> recipeFactory, int defaultEnergy, int defaultWater) {
        super(recipeFactory, defaultEnergy);
        this.defaultWater = defaultWater;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        int water = this.defaultWater;
        float experience = 0.0f;
        int minTicks = -1;
        ArrayList inputItems = new ArrayList();
        ArrayList<FluidStack> inputFluids = new ArrayList<FluidStack>();
        ArrayList outputItems = new ArrayList();
        ArrayList outputItemChances = new ArrayList();
        ArrayList outputFluids = new ArrayList();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("result")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("result"));
        } else if (json.has("results")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("results"));
        } else if (json.has("output")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("output"));
        } else if (json.has("outputs")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("outputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        if (json.has("experience")) {
            experience = json.get("experience").getAsFloat();
        }
        if (json.has("water")) {
            water = json.get("water").getAsInt();
        }
        if (json.has("water_mod")) {
            water = (int)((float)water * json.get("water_mod").getAsFloat());
        }
        if (inputFluids.isEmpty()) {
            inputFluids.add(new FluidStack((Fluid)Fluids.field_204546_a, water));
        }
        if (json.has("min_ticks")) {
            minTicks = json.get("min_ticks").getAsInt();
        }
        return (T)this.factory.create(recipeId, energy, experience, minTicks, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }
}

