/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public abstract class BlockLampBase
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumState> STATE = PropertyEnum.func_177709_a((String)"state", EnumState.class);

    public BlockLampBase() {
        super(Material.field_151573_f);
        this.setRegistryName(this.getLampRegistryName());
        this.func_149663_c("trafficcontrol." + this.getLampRegistryName());
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    protected abstract String getLampRegistryName();

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, STATE});
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(STATE, (Comparable)((Object)EnumState.Off));
    }

    public int func_176201_c(IBlockState state) {
        int modifier = 0;
        switch ((EnumState)((Object)state.func_177229_b(STATE))) {
            case Flash1: {
                modifier = 4;
                break;
            }
            case Flash2: {
                modifier = 8;
                break;
            }
            default: {
                modifier = 0;
            }
        }
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + modifier;
    }

    public IBlockState func_176203_a(int meta) {
        int workingMeta = meta;
        EnumState state = EnumState.Off;
        if (workingMeta >= 4) {
            if (workingMeta >= 8) {
                state = EnumState.Flash2;
                workingMeta -= 8;
            } else {
                state = EnumState.Flash1;
                workingMeta -= 4;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)workingMeta)).func_177226_a(STATE, (Comparable)((Object)state));
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumState enumState = (EnumState)((Object)state.func_177229_b(STATE));
        if (enumState == EnumState.Flash1 || enumState == EnumState.Flash2) {
            return 15;
        }
        return 0;
    }

    public static enum EnumState implements IStringSerializable
    {
        Off(0, "off"),
        Flash1(1, "flash1"),
        Flash2(2, "flash2");

        private int id;
        private String name;

        private EnumState(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public int getID() {
            return this.id;
        }

        public static EnumState getStateByID(int id) {
            for (EnumState state : EnumState.values()) {
                if (state.id != id) continue;
                return state;
            }
            return null;
        }
    }
}

