/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.blocks.BlockHorizontalPole;
import com.clussmanproductions.trafficcontrol.tileentity.SignTileEntity;
import com.clussmanproductions.trafficcontrol.util.UnlistedPropertyInteger;
import com.google.common.base.Predicate;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockSign
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final UnlistedPropertyInteger TYPE = new UnlistedPropertyInteger("type");
    public static final UnlistedPropertyInteger SELECTION = new UnlistedPropertyInteger("selection");
    public static final PropertyBool VALIDHORIZONTALBAR = PropertyBool.func_177716_a((String)"validhorizontalbar");

    public BlockSign() {
        super(Material.field_151573_f);
        this.setRegistryName("sign");
        this.func_149663_c("trafficcontrol.sign");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FACING, VALIDHORIZONTALBAR};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{TYPE, SELECTION};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new SignTileEntity();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean validHorizontalBar = false;
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        validHorizontalBar = currentFacing == EnumFacing.NORTH || currentFacing == EnumFacing.SOUTH ? this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177976_e()), EnumFacing.NORTH, EnumFacing.SOUTH) || this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177974_f()), EnumFacing.NORTH, EnumFacing.SOUTH) : this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177978_c()), EnumFacing.WEST, EnumFacing.EAST) || this.getValidStateForAttachableSubModels(state, worldIn.func_180495_p(pos.func_177968_d()), EnumFacing.WEST, EnumFacing.EAST);
        return state.func_177226_a((IProperty)VALIDHORIZONTALBAR, (Comparable)Boolean.valueOf(validHorizontalBar));
    }

    private boolean getValidStateForAttachableSubModels(IBlockState signState, IBlockState state, EnumFacing ... validFacings) {
        if (state.func_177230_c() == ModBlocks.crossing_gate_pole) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.horizontal_pole) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontalPole.FACING);
            return Arrays.stream(validFacings).noneMatch(vf -> vf.equals((Object)facing));
        }
        if (state.func_177230_c() == ModBlocks.traffic_light) {
            return true;
        }
        if (state.func_177230_c() == ModBlocks.sign) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            return Arrays.stream(validFacings).anyMatch(vf -> vf.equals((Object)facing));
        }
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SignTileEntity) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            SignTileEntity signTE = (SignTileEntity)te;
            extendedState = extendedState.withProperty((IUnlistedProperty)TYPE, (Object)signTE.getType()).withProperty((IUnlistedProperty)SELECTION, (Object)signTE.getVariant());
            return extendedState;
        }
        return super.getExtendedState(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof SignTileEntity)) {
            return false;
        }
        playerIn.openGui((Object)ModTrafficControl.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double poleHeight = 1.0;
        TileEntity worldTE = source.func_175625_s(pos);
        if (!(worldTE instanceof SignTileEntity)) {
            return field_185505_j;
        }
        SignTileEntity te = (SignTileEntity)worldTE;
        if (te != null) {
            int type = te.getType();
            int variant = te.getVariant();
            if (type == 2 && (variant >= 33 && variant <= 40 || variant >= 106 && variant <= 107 || variant >= 110 && variant <= 111)) {
                poleHeight = 0.5;
            }
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.43125, 1.0, poleHeight, 0.5625);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, poleHeight, 0.56875);
            }
            case WEST: {
                return new AxisAlignedBB(0.4375, 0.0, 0.0, 0.56875, poleHeight, 1.0);
            }
            case EAST: {
                return new AxisAlignedBB(0.43125, 0.0, 0.0, 0.5625, poleHeight, 1.0);
            }
        }
        return field_185505_j;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }
}

