/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModBlocks;
import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.StreetLightSingleTileEntity;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class BlockStreetLightSingle
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockStreetLightSingle() {
        super(Material.field_151576_e);
        this.setRegistryName("street_light_single");
        this.func_149663_c("trafficcontrol.street_light_single");
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        int modifier = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0 : 4;
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + modifier;
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = false;
        if (meta > 3) {
            meta -= 4;
            powered = true;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0 : 15;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean powered = world.func_175640_z(pos);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new StreetLightSingleTileEntity();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StreetLightSingleTileEntity) {
            StreetLightSingleTileEntity sls = (StreetLightSingleTileEntity)te;
            sls.removeLightSources();
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StreetLightSingleTileEntity) {
            StreetLightSingleTileEntity streetLightSingleTileEntity = (StreetLightSingleTileEntity)te;
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public float func_185485_f(IBlockState state) {
        return 1.0f;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.field_72995_K) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
            return;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof StreetLightSingleTileEntity) {
            StreetLightSingleTileEntity sls = (StreetLightSingleTileEntity)te;
            boolean shouldUpdate = false;
            if (worldIn.func_175640_z(pos)) {
                sls.removeLightSources();
                shouldUpdate = (Boolean)state.func_177229_b((IProperty)POWERED) == false;
            } else {
                sls.addLightSources();
                shouldUpdate = (Boolean)state.func_177229_b((IProperty)POWERED);
            }
            if (shouldUpdate) {
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(worldIn.func_175640_z(pos))));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent e) {
        if (e.getWorld().field_72995_K) {
            return;
        }
        BlockPos workingPos = new BlockPos(e.getPos().func_177958_n(), e.getPos().func_177956_o(), e.getPos().func_177952_p());
        workingPos = workingPos.func_177964_d(2).func_177985_f(2);
        IBlockState state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && state.func_177229_b((IProperty)FACING) != EnumFacing.EAST && state.func_177229_b((IProperty)FACING) != EnumFacing.SOUTH) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
        workingPos = workingPos.func_177965_g(4);
        state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && state.func_177229_b((IProperty)FACING) != EnumFacing.SOUTH && state.func_177229_b((IProperty)FACING) != EnumFacing.WEST) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
        workingPos = workingPos.func_177970_e(4);
        state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && state.func_177229_b((IProperty)FACING) != EnumFacing.WEST && state.func_177229_b((IProperty)FACING) != EnumFacing.NORTH) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
        workingPos = workingPos.func_177985_f(4);
        state = e.getWorld().func_180495_p(workingPos);
        if (state.func_177230_c() == ModBlocks.street_light_single && state.func_177229_b((IProperty)FACING) != EnumFacing.NORTH && state.func_177229_b((IProperty)FACING) != EnumFacing.EAST) {
            e.getWorld().func_175656_a(e.getPos(), ModBlocks.light_source.func_176223_P());
            e.setCanceled(true);
        }
    }
}

