/*
 * Decompiled with CFR 0.152.
 */
package com.clussmanproductions.trafficcontrol.blocks;

import com.clussmanproductions.trafficcontrol.ModTrafficControl;
import com.clussmanproductions.trafficcontrol.tileentity.Type3BarrierTileEntity;
import com.clussmanproductions.trafficcontrol.tileentity.render.RendererType3Barrier;
import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockType3BarrierBase
extends Block {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static PropertyBool ISFURTHESTLEFT = PropertyBool.func_177716_a((String)"isfurthestleft");
    public static PropertyBool ISFURTHESTRIGHT = PropertyBool.func_177716_a((String)"isfurthestright");

    public BlockType3BarrierBase() {
        super(Material.field_151573_f);
        this.setRegistryName(this.getName());
        this.func_149663_c("trafficcontrol." + this.getName());
        this.func_149711_c(1.0f);
        this.setHarvestLevel("axe", 1);
        this.func_149647_a(ModTrafficControl.CREATIVE_TAB);
    }

    protected abstract String getName();

    public abstract Block getBlockInstance();

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(Type3BarrierTileEntity.class, (TileEntitySpecialRenderer)new RendererType3Barrier());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IProperty[]{ISFURTHESTLEFT}).add(new IProperty[]{ISFURTHESTRIGHT}).build();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean isFurthestLeft = true;
        boolean isFurthestRight = true;
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        EnumFacing directionOfTravel = currentFacing.func_176746_e();
        IBlockState borderState = worldIn.func_180495_p(pos.func_177972_a(directionOfTravel));
        if (borderState.func_177230_c() == this.getBlockInstance()) {
            boolean bl = isFurthestRight = borderState.func_177229_b((IProperty)FACING) != currentFacing;
        }
        if ((borderState = worldIn.func_180495_p(pos.func_177972_a(directionOfTravel = currentFacing.func_176735_f()))).func_177230_c() == this.getBlockInstance()) {
            isFurthestLeft = borderState.func_177229_b((IProperty)FACING) != currentFacing;
        }
        return state.func_177226_a((IProperty)ISFURTHESTLEFT, (Comparable)Boolean.valueOf(isFurthestLeft)).func_177226_a((IProperty)ISFURTHESTRIGHT, (Comparable)Boolean.valueOf(isFurthestRight));
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (currentFacing) {
            case NORTH: 
            case SOUTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.5625, 1.0, 1.4375, 0.4375);
            }
            case WEST: 
            case EAST: {
                return new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.4375, 1.0);
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity teInPos = worldIn.func_175625_s(pos);
        if (!(teInPos instanceof Type3BarrierTileEntity)) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        Type3BarrierTileEntity barrierTE = (Type3BarrierTileEntity)teInPos;
        playerIn.openGui((Object)ModTrafficControl.instance, 4, worldIn, barrierTE.func_174877_v().func_177958_n(), barrierTE.func_174877_v().func_177956_o(), barrierTE.func_174877_v().func_177952_p());
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new Type3BarrierTileEntity();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.field_72995_K) {
            return;
        }
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        if (!((Boolean)actualState.func_177229_b((IProperty)ISFURTHESTLEFT)).booleanValue() || !((Boolean)actualState.func_177229_b((IProperty)ISFURTHESTRIGHT)).booleanValue()) {
            Type3BarrierTileEntity myTE = (Type3BarrierTileEntity)worldIn.func_175625_s(pos);
            EnumFacing facing = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
            BlockPos leftPos = pos.func_177972_a(facing.func_176735_f());
            Type3BarrierTileEntity leftTE = (Type3BarrierTileEntity)worldIn.func_175625_s(leftPos);
            BlockPos rightPos = pos.func_177972_a(facing.func_176746_e());
            Type3BarrierTileEntity rightTE = (Type3BarrierTileEntity)worldIn.func_175625_s(rightPos);
            if (leftTE == null) {
                myTE.setRenderSign(rightTE.getRenderSign());
                myTE.setSignType(rightTE.getSignType());
            } else if (rightTE == null) {
                myTE.setRenderSign(leftTE.getRenderSign());
                myTE.setSignType(leftTE.getSignType());
            } else {
                boolean renderSign = leftTE.getRenderSign() || rightTE.getRenderSign();
                leftTE = myTE.findFurthestLeft();
                leftTE.setRenderSign(renderSign);
                leftTE.setSignType(leftTE.getSignType());
                leftTE.syncConnectedBarriers(false);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }
}

